<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\InstallController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\BrandingController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\QuickAddController;
use App\Http\Controllers\ResourceController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\TourGuideController;
use App\Http\Controllers\SMTPServerController;
use App\Http\Controllers\Charts\ChartController;
use App\Http\Controllers\SecurityCheckController;
use App\Http\Controllers\DataConnectionController;
use App\Http\Controllers\Metrics\MetricController;
use App\Http\Controllers\DashboardWidgetController;
use App\Http\Controllers\GeneralSettingsController;
use App\Http\Controllers\Charts\ChartBuildController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\DataConnectionTablesController;
use App\Http\Controllers\Charts\ChartDrillPrintController;
use App\Http\Controllers\Charts\Wizard\DataStepController;
use App\Http\Controllers\Charts\ChartDrillExportController;
use App\Http\Controllers\Charts\ChartDetailsPrintController;
use App\Http\Controllers\Metrics\MetricDrillPrintController;
use App\Http\Controllers\Charts\ChartDetailsExportController;
use App\Http\Controllers\Charts\Wizard\SettingStepController;
use App\Http\Controllers\Metrics\MetricDrillExportController;
use App\Http\Controllers\ScheduledReports\ScheduledReportsController;
use App\Models\Setting;

Route::get('/setup', [InstallController::class, 'install'])->name("install");

Route::middleware("isinstalled")->group(function () {

    Route::middleware(["auth", "tour.guide",'eviction'])->group(function () {

        //home routes
        Route::get('/', [HomeController::class, 'index'])->name('home');
        Route::get('/widgets/create', [HomeController::class, 'create'])->name('home.widgets.create');
        Route::post('/widgets', [HomeController::class, 'store'])->name('home.widgets.store');
        Route::get('/widgets/{widget}/edit', [HomeController::class, 'edit'])->name('home.widgets.edit');
        Route::put('/widgets/{widget}', [HomeController::class, 'update'])->name('home.widgets.update');
        Route::delete('/widgets/{widget}', [HomeController::class, 'destroy'])->name('home.widgets.destroy');

        // Route::get('/reports', [ReportController::class, "show"])->name('reports');

        // dashboards routes
        Route::get('/dashboards', [DashboardController::class, 'index'])->name('dashboards.index');
        Route::post('/dashboards', [DashboardController::class, 'store'])->name('dashboards.store');
        Route::get('/dashboards/create', [DashboardController::class, 'create'])->name('dashboards.create');
        Route::get('/dashboards/{dashboard}', [DashboardController::class, 'show'])->name('dashboards.show');
        Route::get('/dashboards/{dashboard}/edit', [DashboardController::class, 'edit'])->name('dashboards.edit');
        Route::put('/dashboards/{dashboard}', [DashboardController::class, 'update'])->name('dashboards.update');
        Route::patch('/dashboards/{dashboard}/moveUp', [DashboardController::class, 'moveUp'])->name('dashboards.moveUp');
        Route::patch('/dashboards/{dashboard}/moveDown', [DashboardController::class, 'moveDown'])->name('dashboards.moveDown');
        Route::delete('/dashboards/{dashboard}', [DashboardController::class, 'destroy'])->name('dashboards.destroy');

        // dashboard widgets routes

        Route::post('/dashboards/{dashboard}', [DashboardWidgetController::class, 'store'])->name('dashboards.widgets.store');
        Route::get('/dashboards/{dashboard}/create', [DashboardWidgetController::class, 'create'])->name('dashboards.widgets.create');
        Route::get('/dashboards/{dashboard}/{widget}/edit', [DashboardWidgetController::class, 'edit'])->name('dashboards.widgets.edit');
        Route::put('/dashboards/{dashboard}/{widget}', [DashboardWidgetController::class, 'update'])->name('dashboards.widgets.update');
        Route::delete('/dashboards/{dashboard}/{widget}', [DashboardWidgetController::class, 'destroy'])->name('dashboards.widgets.destroy');

        //profile routes
        Route::get('/profile', [ProfileController::class, 'index'])->name('profile.index');
        Route::post('/profile/updateContactDetails', [ProfileController::class, 'updateContactDetails'])->name('profile.updateContactDetails');
        Route::post('/profile/updateOrganizationDetails', [ProfileController::class, 'updateOrganizationDetails'])->name('profile.updateOrganizationDetails');
        Route::post('/profile/changePassword', [ProfileController::class, 'changePassword'])->name('profile.changePassword');
        Route::post('/profile/saveLogo', [ProfileController::class, 'storeOrganizationLogo'])->name('profile.storeOrganizationLogo');
        Route::post('/profile/removeLogo', [ProfileController::class, 'removeOrganizationLogo'])->name('profile.removeOrganizationLogo');

        Route::middleware(['onlyAdmin'])->group(function () {
            //users routes
            Route::patch('/users/{user}/activate', [UserController::class, 'activate'])->name('users.activate');
            Route::patch('/users/{user}/activate-admin', [UserController::class, 'activateAdmin'])->name('users.activate-admin');
            Route::patch('/users/{user}/block', [UserController::class, 'block'])->name('users.block');
            Route::patch('/users/{user}/unblock', [UserController::class, 'unblock'])->name('users.unblock');
            Route::delete('/users/{user}/delete', [UserController::class, 'destroy'])->name('users.destroy');

            Route::get('/users', [UserController::class, 'index'])->name('users.index');
            Route::post('/users', [UserController::class, 'store'])->name('users.store');
            Route::get('/users/{user}', [UserController::class, 'edit'])->name('users.edit');
            Route::put('/users/{user}', [UserController::class, 'update'])->name('users.update');

            //group
            Route::post('/groups', [GroupController::class, 'store'])->name('groups.store');
            Route::get('/groups/{group}/edit', [GroupController::class, 'edit'])->name('groups.edit');
            Route::delete('/groups/{group}', [GroupController::class, 'destroy'])->name('groups.destroy');
            Route::put('/groups/{group}', [GroupController::class, 'update'])->name('groups.update');

            //data connections

            Route::get('/data_connections', [DataConnectionController::class, 'index'])->name('data_connections.index');
            Route::get('/data_connections/{connection}/edit', [DataConnectionController::class, 'edit'])->name('data_connections.edit');
            Route::delete('/data_connections/{connection}', [DataConnectionController::class, 'destroy'])->name('data_connections.destroy');
            Route::put('/data_connections/{connection}', [DataConnectionController::class, 'update'])->name('data_connections.update');
            Route::post('/data_connections', [DataConnectionController::class, 'store'])->name('data_connections.store');
            Route::post('/data_connections/test', [DataConnectionController::class, 'testConnection'])->name('data_connections.testConnection');

            //categories
            Route::get('/categories', [CategoryController::class, 'index'])->name('categories.index');
            Route::get('/categories/{category}/edit', [CategoryController::class, 'edit'])->name('categories.edit');
            Route::delete('/categories/{category}', [CategoryController::class, 'destroy'])->name('categories.destroy');
            Route::put('/categories/{category}', [CategoryController::class, 'update'])->name('categories.update');
            Route::post('/categories', [CategoryController::class, 'store'])->name('categories.store');

            //general
            Route::get('/general', [GeneralSettingsController::class, 'index'])->name('general.index');
            Route::put('/general', [GeneralSettingsController::class, 'update'])->name('general.update');

            Route::post('/smtp_servers/test', [SMTPServerController::class, 'test'])->name('smtp_servers.test');
            Route::post('/smtp_servers/update', [SMTPServerController::class, 'update'])->name('smtp_servers.update');

            Route::post('/branding', [BrandingController::class, 'update'])->name('branding.update');
            Route::delete('/branding', [BrandingController::class, 'destroy'])->name('branding.destroy');

            // scheduled reports
            Route::get('/scheduled-reports', [ScheduledReportsController::class, 'index'])->name('scheduled-reports.index');
            Route::get('/scheduled-reports/create', [ScheduledReportsController::class, 'create'])->name('scheduled-reports.create');
            Route::post('/scheduled-reports', [ScheduledReportsController::class, 'store'])->name('scheduled-reports.store');
            Route::get('/scheduled-reports/{scheduledTask}/log', [ScheduledReportsController::class, 'log'])->name('scheduled-reports.log');
            Route::post('/scheduled-reports/{scheduledTask}/send', [ScheduledReportsController::class, 'send'])->name('scheduled-reports.send');
            Route::get('/scheduled-reports/{scheduledTask}/edit', [ScheduledReportsController::class, 'edit'])->name('scheduled-reports.edit');
            Route::put('/scheduled-reports/{scheduledTask}', [ScheduledReportsController::class, 'update'])->name('scheduled-reports.update');
            // Route::get('/scheduled-reports/{report}/get-categories', [ScheduledReportsController::class, 'getCategories'])->name('scheduled-reports.getCategories');
            // Route::patch('/scheduled-reports/{report}', [ScheduledReportsController::class, 'changeCategory'])->name('scheduled-reports.changeCategory');
            Route::patch('/scheduled-reports/{scheduledTask}/stop', [ScheduledReportsController::class, 'stop'])->name('scheduled-reports.stop');
            Route::patch('/scheduled-reports/{scheduledTask}/resume', [ScheduledReportsController::class, 'resume'])->name('scheduled-reports.resume');
            Route::delete('/scheduled-reports/{scheduledTask}', [ScheduledReportsController::class, 'destroy'])->name('scheduled-reports.destroy');

        });

        // reports
        Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
        Route::get('/reports/create', [ReportController::class, 'create'])->name('reports.create');
        Route::get('/reports/{report}', [ReportController::class, 'show'])->name('reports.show');
        Route::get('/reports/{report}/edit', [ReportController::class, 'edit'])->name('reports.edit');
        Route::get('/reports/{report}/get-categories', [ReportController::class, 'getCategories'])->name('reports.getCategories');
        Route::patch('/reports/{report}', [ReportController::class, 'changeCategory'])->name('reports.changeCategory');
        Route::delete('/reports/{report}', [ReportController::class, 'destroy'])->name('reports.destroy');

        // ================================== start charts ==================================
        Route::get('/charts', [ChartController::class, 'index'])->name('charts.index');

        Route::get('/charts/{date_range}/get_scales', [ChartController::class, 'getScales'])->name('charts.getScales');

        Route::get('/charts/create/appearance', [App\Http\Controllers\Charts\Wizard\ApperanceStepController::class, 'show'])->name('charts.wizard.appearance.show');
        Route::post('/charts/create/appearance', [App\Http\Controllers\Charts\Wizard\ApperanceStepController::class, 'store'])->name('charts.wizard.appearance.store');

        Route::get('/charts/edit/appearance/{chart}', [App\Http\Controllers\Charts\Wizard\ApperanceStepController::class, 'edit'])->name('charts.wizard.appearance.edit');
        // Route::post('/charts/edit/appearance/{chart}', [App\Http\Controllers\Charts\Wizard\ApperanceStepController::class,'update'])->name('charts.wizard.appearance.update');

        Route::post('/charts/create/settings', [SettingStepController::class, 'store'])->name('charts.wizard.setting.store');

        Route::put('/charts/edit/settings/{chart}', [SettingStepController::class, 'update'])->name('charts.wizard.setting.update');

        Route::post('/charts/create/data', [DataStepController::class, 'store'])->name('charts.wizard.data.store');

        Route::post('/charts/edit/data/{chart}', [DataStepController::class, 'update'])->name('charts.wizard.data.update');

        Route::get('/charts/{chart}/get-categories', [ChartController::class, 'getCategories'])->name('charts.getCategories');
        // Route::get('/charts/drill/{chart}/{xValue?}', [ChartController::class, 'drill'])->name('charts.drill');

        Route::patch('/charts/{chart}/change-category', [ChartController::class, 'changeCategory'])->name('charts.changeCategory');
        Route::delete('/charts/{chart}', [ChartController::class, 'destroy'])->name('charts.destroy');

        Route::get('/charts/forgetSession', [ChartController::class, 'forgetSession'])->name('charts.forgetSession');
        // ================================== end charts ==================================

        // ================================== start metrics ==================================

        Route::get('/metrics', [MetricController::class, 'index'])->name('metrics.index');
        Route::get('/metrics/{metric}/get-categories', [MetricController::class, 'getCategories'])->name('metrics.getCategories');
        Route::patch('/metrics/{metric}/change-category', [MetricController::class, 'changeCategory'])->name('metrics.changeCategory');
        Route::delete('/metrics/{metric}', [MetricController::class, 'destroy'])->name('metrics.destroy');

        Route::get('/metrics/create/appearance', [App\Http\Controllers\Metrics\Wizard\ApperanceStepController::class, 'show'])->name('metrics.wizard.appearance.show');
        Route::post('/metrics/create/appearance', [App\Http\Controllers\Metrics\Wizard\ApperanceStepController::class, 'store'])->name('metrics.wizard.appearance.store');

        Route::get('/metrics/edit/appearance/{metric}', [App\Http\Controllers\Metrics\Wizard\ApperanceStepController::class, 'edit'])->name('metrics.wizard.appearance.edit');

        Route::post('/metrics/create/settings', [App\Http\Controllers\Metrics\Wizard\SettingStepController::class, 'store'])->name('metrics.wizard.setting.store');
        Route::put('/metrics/edit/settings/{metric}', [App\Http\Controllers\Metrics\Wizard\SettingStepController::class, 'update'])->name('metrics.wizard.setting.update');

        Route::post('/metrics/create/data', [App\Http\Controllers\Metrics\Wizard\DataStepController::class, 'store'])->name('metrics.wizard.data.store');

        Route::post('/metrics/edit/data/{metric}', [App\Http\Controllers\Metrics\Wizard\DataStepController::class, 'update'])->name('metrics.wizard.data.update');

        // ================================== end metrics ==================================

        Route::get('/data_connections/{connection}/get_tables', [DataConnectionTablesController::class, 'getTables'])->name('data_connections.getTables');
        Route::get('/data_connections/{connection}/{table}/get_columns', [DataConnectionTablesController::class, 'getColumns'])->name('data_connections.getColumns');
        Route::get('/data_connections/{connection}/{table}/{column}/get_column_type', [DataConnectionTablesController::class, 'getColumnType'])->name('data_connections.getColumnType');
        Route::get('/data_connections/{connection}/{table}/{column}/get_values', [DataConnectionTablesController::class, 'getValues'])->name('data_connections.getValues');

        // security check
        Route::get('/securityCheck', SecurityCheckController::class)->name('securityCheck');

        //misc routes

        Route::get('/getAllResourcesByModuleId/{resource}', [ResourceController::class, 'getAllResourcesByModuleId'])->name('resources.getAllResourcesByModuleId');
        Route::get('quick-add', QuickAddController::class)->name('quick-add');

        Route::post('/tour/start', [TourGuideController::class, 'start'])->name('tour.start');
        Route::post('/tour/stop', [TourGuideController::class, 'stop'])->name('tour.stop');
        Route::post('/tour/step', [TourGuideController::class, 'step'])->name('tour.step');
        Route::post('/tour/rewatch', [TourGuideController::class, 'rewatch'])->name('tour.rewatch');

    });

    // ================================== start public charts ==================================

    Route::get('/srm_charts/{chart}', [ChartController::class, 'show'])->name('charts.show');
    Route::get('/charts/details/{chart}', [ChartController::class, 'details'])->name('charts.details');
    Route::get('/charts/build/{chart}', ChartBuildController::class)->name('charts.build');

    Route::post('/charts/details/{chart}/export', ChartDetailsExportController::class)->name('charts.details.export');
    Route::get('/charts/drill/{chart}/export', ChartDrillExportController::class)->name('charts.drill.export');

    Route::post('/charts/details/{chart}/print', ChartDetailsPrintController::class)->name('charts.details.print');
    Route::get('/charts/drill/{chart}/print', ChartDrillPrintController::class)->name('charts.drill.print');
    Route::get('/charts/drill/{chart}', [ChartController::class, 'drill'])->name('charts.drill');

    // Route::get('/charts/details/{chart}/autoexport', [ChartController::class,'autoexport'])->name('charts.autoexport');
    // Route::post('/charts/details/{chart}/autoexport', ChartDetailsAutoExportController::class)->name('charts.details.autoexport');

    Route::get('/charts/{chart}/generateDetails', [ChartController::class, 'generateDetails'])->name('charts.details.generate');

    // ================================== end public charts ==================================

    // ================================== start public metrics ==================================
    Route::get('/srm_metrics/{metric}', [MetricController::class, 'show'])->name('metrics.show');
    Route::get('/metrics/drill/{metric}', [MetricController::class, 'drill'])->name('metrics.drill');
    Route::post('/metrics/drill/{metric}/export', MetricDrillExportController::class)->name('metrics.drill.export');
    Route::post('/metrics/drill/{metric}/print', MetricDrillPrintController::class)->name('metrics.drill.print');

    // ================================== end public metrics ==================================

    Auth::routes([
        'verify' => true
    ]);

    Route::post('/password/security_question', [ForgotPasswordController::class, 'getSecurityQuestion'])->name('password.security_question');

    Route::get('/resetSharedKey', function (){
        DB::table('srm_Settings')->where('settings_key' , "shared_key")->delete();

        DB::table('srm_Settings')->updateOrInsert(
            ['settings_key' => "shared_key"],
            ['settings_value' => encrypt(base64_encode(random_bytes(256)))]
        );
    });

});