<aside class="main-sidebar sidebar-dark-primary sidebar-no-expand elevation-4">
    <div class="bg-white p-2 branding-logo">
        <a href="{{ route('home') }}">
            @if(is_null(getSettingsValue('system_logo')))
            <img src="{{ get_asset('dist/images/srm-logo.jpg') }}" alt="Logo" class="brand-image img-fluid" />
            @else
            <img src="{{ getSystemLogo() }}" alt="Logo" class="brand-image img-fluid" />
            @endif
        </a>
    </div>
    <div class="sidebar">
        <div class="user-panel py-2 d-flex">
            <div class="image py-1">
                <i class="fa-regular fa-circle-user"></i>
            </div>
            <div class="info">
                <span href="#" class="d-block">Welcome

                    <a class="text-white" href="{{ route('profile.index') }}">
                        @if(checkDemo())
                        admin
                        @else
                        {{ isset(auth()->user()->user_name) ? auth()->user()->user_name :'' }}
                        @endif
                    </a></span>

            </div>
        </div>
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <li class="nav-item">
                    <a href="{{ route('home') }}"
                        class="nav-link home-page {{ Route::currentRouteNamed('home') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-home"></i>
                        <p>Home</p>
                    </a>
                </li>
                <li class="nav-item dashboard-page {{ Route::currentRouteNamed('dashboards.*') ? 'menu-open' : '' }}">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>
                            Dashboards
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview" id="dashboard-aside-container">
                        <li class="nav-item">
                            <a href="{{ route('dashboards.index') }}"
                                class="nav-link {{ Route::currentRouteNamed('dashboards.index') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>Dashboard Manager</p>
                            </a>
                        </li>
                        @foreach ($userDashboards as $userDashboard)

                        <li class="nav-item">
                            <a href="{{ route('dashboards.show',[$userDashboard->id]) }}" class="nav-link {{ Route::currentRouteNamed('dashboards.show') && request()->
                            route('dashboard')->id == $userDashboard->id ? 'active' : '' }}">
                                <i class="nav-icon fa fa-fw" style="font-family: 'FontAwesome'"> {!! '&'.
                                    $userDashboard->icon
                                    !!}</i>

                                {{-- <i class="nav-icon fas fa-tachometer-alt"></i> --}}
                                <p>{{ $userDashboard->name }}</p>
                            </a>
                        </li>
                        @endforeach
                    </ul>
                </li>
                <li class="nav-item">
                    <a href="{{ route('reports.index') }}"
                        class="nav-link reports-page {{ Route::currentRouteNamed('reports.*') ? 'active' : ''}}">
                        <i class="nav-icon fas fa-chart-simple"></i>
                        <p>Reports</p>
                    </a>
                </li>
                @if(auth()->user()->isAdminOrOwner())
                <li class="nav-item">
                    <a href="{{ route('scheduled-reports.index') }}"
                        class="nav-link scheduled-reports-page {{ Route::currentRouteNamed('scheduled-reports.*') ? 'active' : ''}}">
                        <i class="nav-icon fas fa-calendar-days"></i>
                        <p>Scheduled Reports</p>
                    </a>
                </li>
                @endif
                <li class="nav-item">
                    <a href="{{ route('charts.index') }}"
                        class="nav-link charts-page {{ Route::currentRouteNamed('charts.*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-chart-line"></i>
                        <p>Charts</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('metrics.index') }}"
                        class="nav-link kpis-page {{ Route::currentRouteNamed('metrics.*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-timeline"></i>
                        <p>KPIs / Metrics</p>
                    </a>
                </li>
                @if(auth()->user()->isAdminOrOwner())
                <li
                    class="nav-item {{ (Route::currentRouteNamed('general.index') || Route::currentRouteNamed('data_connections.index') ||
                Route::currentRouteNamed('categories.index') || Route::currentRouteNamed('users.index') || (!checkDemo() && !isCheckedGuidedTour())) ? 'menu-open' : '' }}">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fa-solid fa-gear"></i>
                        <p>
                            Settings
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('general.index') }}"
                                class="nav-link {{ Route::currentRouteNamed('general.index') ? 'active' : ''}}">
                                <i class="nav-icon fa-solid fa-wrench"></i>
                                <p>General</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('data_connections.index') }}"
                                class="nav-link data-connection-page {{ Route::currentRouteNamed('data_connections.index') ? 'active' : ''}}">
                                <i class="nav-icon fa-solid fa-database"></i>
                                <p>Data Connections</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('categories.index') }}"
                                class="nav-link {{ Route::currentRouteNamed('categories.index') ? 'active' : ''}}">
                                <i class="nav-icon fas fa-list-alt"></i>
                                <p>Categories</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('users.index') }}"
                                class="nav-link {{ Route::currentRouteNamed('users.index') ? 'active' : ''}}">
                                <i class="nav-icon fa-solid fa-users"></i>
                                <p>Users</p>
                            </a>
                        </li>
                    </ul>
                </li>
                @endif
            </ul>
        </nav>
    </div>
</aside>
