<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Smart Report Maker</title>

    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback"
        crossorigin="anonymous" />

    <link rel="stylesheet" href="{{ get_asset('dist/css/all.min.css')}}">
    <link rel="stylesheet" href="{{ get_asset('dist/css/adminlte.min.css')}}">
    <link rel="stylesheet" href="{{ get_asset('dist/css/style.css')}}" />

    <link rel="stylesheet" href="{{ get_asset('dist/css/driver.css') }}">
    <link rel="stylesheet" href="{{ get_asset('dist/css/tour.css') }}">


    <script src="{{ get_asset('dist/js/jquery.min.js')}}"></script>
    <script src="{{ get_asset('dist/js/dotlottie-player.mjs') }}" type="module">
    </script>

    <script src="{{ get_asset('dist/js/head.js')}}"></script>

    @yield('styles')
    @yield('head-scripts')
</head>

<body class="hold-transition sidebar-mini">
    @include('partials._quick-add-blue')
    @include('partials._info')
    <div id="global-loader">
        <dotlottie-player class="loader-img" src="{{ get_asset('dist/images/loader.json') }}" background="transparent"
            speed="1" style="width: 150px; height: 150px;" loop autoplay></dotlottie-player>
        <div class="loader-text"></div>
    </div>

    @include('partials._demo-modal')
    @include('partials._tour-confirmation',[
    'id' => 'tour-rewatch',
    'modal_title' =>'Rewatch The Guided Tour',
    'method'=> 'POST'
    ])
    <div class="wrapper">
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <div class="d-flex justify-content-between mb-1">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                                class="fas fa-bars"></i></a>
                    </li>
                    <li class="nav-item d-none d-sm-inline-block">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" data-toggle="tooltip"
                            data-placement="top" title="Home" href="{{ route('home') }}">
                            <i class="fa-solid fa-house"></i>
                        </a>
                    </li>
                </ul>
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item dropdown">
                        <button class="bg-white mx-2 my-1 border-0" data-toggle="modal" data-target="#quick-add-modal">

                            {{-- <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                class="bi bi-plus-circle" viewBox="0 0 16 16" data-toggle="tooltip" data-placement="top"
                                title="Quick add">
                                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16" />
                                <path
                                    d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4" />
                            </svg> --}}
                            <svg fill="#000000" viewBox="0 0 24 24" width="20" height="20"
                                xmlns="http://www.w3.org/2000/svg" data-toggle="tooltip" data-placement="top"
                                title="Quick add">

                                <g data-name="Layer 2">

                                    <g data-name="plus-circle">

                                        <rect width="24" height="24" opacity="0" viewBox="0 0 24 24" />

                                        <path
                                            d="M12 2a10 10 0 1 0 10 10A10 10 0 0 0 12 2zm0 18a8 8 0 1 1 8-8 8 8 0 0 1-8 8z" />

                                        <path
                                            d="M15 11h-2V9a1 1 0 0 0-2 0v2H9a1 1 0 0 0 0 2h2v2a1 1 0 0 0 2 0v-2h2a1 1 0 0 0 0-2z" />

                                    </g>

                                </g>

                            </svg>

                            {{-- <span class="fa-stack custom-icon" data-toggle="tooltip" data-placement="top"
                                title="Quick add">
                                <i class="fa-regular fa-circle fa-stack-2x"></i>
                                <i class="fa-solid fa-plus fa-stack-1x"></i>
                            </span> --}}

                        </button>
                    </li>

                    @if(checkDemo())
                    <li class="nav-item">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" id="start-demo-tour"
			    data-toggle="tooltip" data-placement="top" title="Guided Tour" data-image="{{ get_asset('dist/images/srm-logo.jpg')}}">
                            <i class="fa-solid fa-repeat"></i>
                        </a>
                    </li>
                    @else
                    <li class="nav-item">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" id="start-tour"
                            data-toggle="tooltip" data-placement="top" title="Guided Tour" data-image="{{ get_asset('dist/images/srm-logo.jpg')}}" 
                            data-start="{{ route('tour.start') }}" data-step="{{ route('tour.step') }}"
                            data-stop="{{ route('tour.stop') }}">
                            <i class="fa-solid fa-repeat"></i>
                        </a>
                    </li>
                    @endif

                    <li class="nav-item dropdown">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" data-toggle="tooltip"
                            data-placement="top" title="Profile" href="{{ route('profile.index') }}">
                            <i class="fa-solid fa-user"></i>
                        </a>
                    </li>
                    <li class="nav-item dropdown">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" data-toggle="tooltip"
                            data-placement="top" title="help" target="_blank"
                            href="https://mysqlreports.com/smart-report-maker-docs/smart-report-maker-docs/">
                            <i class="fa-solid fa-question-circle"></i>
                        </a>
                    </li>


                    {{-- <li class="nav-item dropdown">
                        <div class="dropdown">
                            <a type="button" class="btn btn-secondary bg-white mx-2 border-0" data-toggle="tooltip"
                                data-placement="top" title="Notifications" id="notificationButton">
                                <div class="notification-badge" id="notificationBadge">
                                    <span class="badge badge-danger">3</span>
                                </div>
                                <i class="fa-solid fa-bell" id="notificationBell"></i>
                            </a>

                            <div class="dropdown-menu" style="width: 700px;" id="notificationDropdown">
                                <a class="dropdown-item" href="#">You have 3 Notifications</a>
                                <hr class="dropdown-divider" />

                                <a class="dropdown-item my-2 notification-item d-flex align-items-center" href="#">
                                    <i class="fa-solid fa-envelope fa-lg"></i>
                                    <span class="notification-text ml-2 mr-5">Notification 1</span>
                                    <button class="btn btn-sm btn-primary mark-as-read-button ml-auto">
                                        Mark As Read
                                    </button>
                                </a>

                                <hr class="dropdown-divider" />

                                <a class="dropdown-item my-2 notification-item d-flex align-items-center" href="#">
                                    <i class="fa-solid fa-envelope fa-lg"></i>
                                    <span class="notification-text ml-2 mr-5">Notification 2</span>
                                    <button class="btn btn-sm btn-primary mark-as-read-button ml-auto">
                                        Mark As Read
                                    </button>
                                </a>

                                <hr class="dropdown-divider" />

                                <a class="dropdown-item my-2 notification-item d-flex align-items-center" href="#">
                                    <i class="fa-solid fa-envelope fa-lg"></i>
                                    <span class="notification-text ml-2 mr-5">Notification 3</span>
                                    <button class="btn btn-sm btn-primary mark-as-read-button ml-auto">
                                        Mark As Read
                                    </button>
                                </a>
                                <hr class="dropdown-divider" />
                                <div class="text-center">
                                    <button class="btn btn-sm btn-light mx-2" style=" text-decoration: underline;">
                                        Check All Notifications
                                    </button>
                                    <button class="btn btn-sm btn-success mx-2" id="markAllAsReadButton">
                                        Mark All As Read
                                    </button>
                                </div>
                            </div>
                        </div>
                    </li> --}}

                    @if(checkDemo())
                    <li class="nav-item">
                        <a type="button" target="_blank" href="{{ config('srm_config.dashboard.demo.Buy_link') }}"
                            class="btn btn-secondary bg-white mx-2 border-0" data-toggle="tooltip" data-placement="top"
                            title="Purchase">
                            <i class="fa-solid fa-cart-shopping"></i>
                        </a>
                    </li>
                    @endif

                    @if(auth()->user()->isAdminOrOwner() && !checkDemo())
                    <li class="nav-item dropdown">
                        <button type="button" class="btn btn-secondary bg-white mx-2 border-0" data-placement="top"
                            title="info" data-toggle="modal" data-tooltip-toggle="tooltip" data-target="#info-modal">
                            <i class="fa-solid fa-info-circle"></i>
                        </button>
                    </li>
                    @endif

                    <li class="nav-item">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" data-toggle="tooltip"
                            data-placement="top" title="Logout" onclick="event.preventDefault();
                            document.getElementById('logout-form').submit();">
                            <i class="fa-solid fa-right-from-bracket"></i>
                        </a>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                            @csrf
                        </form>

                    </li>
                </ul>
            </div>
            <div class="d-flex justify-content-between">
                <div class="alert bootstrap-alert-danger flex-grow-1 ml-3" role="alert"
                    style="max-width: 80%; {{ empty(session('security_errors')) ? 'display: none' : '' }}">
                    @if(!empty(session('security_errors')))
                    <ul class="mb-0 text-left">
                        @if(isset(session('security_errors')['security_check_error']))
                        <li id="security-error-alert">{{ session('security_errors')['security_check_error'] }} <a
                                class="text-decoration-none text-primary {{ isset(session('security_errors')['security_check_error']) ? '' : 'd-d-none' }}"
                                href="{{ route('securityCheck') }}">check
                                now</a></li>
                        @endif
                        @if(isset(session('security_errors')['install_check_error']))
                        <li>{{ session('security_errors')['install_check_error'] }}</li>
                        @endif

                        @if(isset(session('security_errors')['install_script_check_error']))
                        <li>{{ session('security_errors')['install_script_check_error'] }}</li>
                        @endif

                        @if(isset(session('security_errors')['user_security_question_check_error']))
                        <li>{!! session('security_errors')['user_security_question_check_error'] !!}</li>
                        @endif
                    </ul>

                    @endif
                </div>
                {{-- <div class="col-auto mr-2">
                    <button class="btn btn-success font-weight-bold srm-button px-4 py-2" data-toggle="modal"
                        data-target="#quick-add-modal">
                        <i class="fas fa-solid fa-plus mr-1 mb-0"> </i>
                        Quick Add
                    </button>
                </div> --}}
            </div>
        </nav>
        @include('partials._aside')
        @yield('content')
    </div>
    <script type="text/javascript" src="{{ get_asset('dist/js/bootstrap.bundle.min.js')}}"></script>
    <script type="text/javascript" src="{{ get_asset('dist/js/index.js') }}"></script>
    <script type="text/javascript" src="{{ get_asset('dist/js/adminlte.min.js')}}"></script>
    <script type="text/javascript" src="{{ get_asset('dist/js/dashboard.js')}}"></script>
    <script src="{{ get_asset('dist/js/driver.js') }}"></script>
    <script src="{{ get_asset('dist/js/tour/tour-guide.js') }}"></script>

    @if(checkDemo())

    @if(session('tour_guide_shown'))
    <script src="{{ get_asset('dist/js/tour-demo-guide.js') }}"></script>
    @endif
    <script src="{{ get_asset('dist/js/start-demo-tour.js') }}"></script>
    @endif

    @if(!checkDemo() && !isCheckedGuidedTour())
    <script>
        {!! tourScript() !!}
    </script>

    @endif

    <script>
        $(function() {
            $("#global-loader").fadeOut("slow");
        });
        window.addEventListener("beforeunload", function (event) {
            $("#global-loader").fadeIn();
        });
    </script>
    @yield('scripts')
</body>

</html>
