<div class="modal fade" id="edit-user-modal" tabindex="-1" role="dialog" aria-labelledby="activate-user-modal"
    aria-modal="true">
    <div class="modal-dialog modal-dialog-centered  modal-lg" role="document">
        <div class="modal-content custom-rounded-edges">
            <div class="modal-header">
                <h5 class="modal-title ml-2" id="exampleModalLongTitle">
                    <i class="fa-solid fa-user mx-2"></i>
                    User Details
                </h5>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form data-url="{{ route('users.update',$user->user_ID) }}" id="edit-user-form">

                <div class="modal-body mx-3 my-2">

                    <div class="row">
                        <div class="col-md-6">
                            @csrf
                            @method('PUT')
                            <div class="form-group">
                                <label for="first_name">First Name</label>
                                <input type="text" class="form-control" id="first_name" name="first_name"
                                    @if(checkDemo()) value="<firstname>" @else value="{{ $user->first_name }}" @endif>
                            </div>
                            <div class="form-group">
                                <label for="user_name">User Name</label>
                                <input type="text" class="form-control" id="user_name" name="user_name" @if(checkDemo())
                                    value="<username>" @else value="{{ $user->user_name }}" @endif>
                            </div>
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="text" class="form-control" id="email" name="Email" @if(checkDemo())
                                    value="<Email>" @else value="{{ $user->Email }}" @endif>
                            </div>
                            <div class="form-group">
                                <label for="email">Phone</label>
                                <input type="text" class="form-control" id="phone" name="Phone"
                                    value="{{ $user->Phone }}">
                            </div>
                            <div class="form-group">
                                <label for="email_confirm">Email Confirmation</label>
                                <select class="form-control" id="email-confirmation" name="email_confirm">
                                    <option value="yes" {{ isset($user->email_verified_at) ? 'selected' : ''}}>User
                                        verified his email</option>
                                    <option value="no" {{ isset($user->email_verified_at) ? '' : 'selected'}} >User
                                        didn't verify his email</option>
                                </select>
                            </div>
                            <div class="form-group form-check">
                                <input type="checkbox" class="form-check-input" id="resetPassword"
                                    name="reset_password">
                                <label class="form-check-label" for="resetPassword">Reset Password</label>
                            </div>
                            <div class="form-group form-check">
                                <input type="checkbox" class="form-check-input" id="sendEmailActivation"
                                    name="send_activation">
                                <label class="form-check-label" for="sendEmailActivation">Send Email Activation</label>
                            </div>
                        </div>
                        <div class="col-md-6">

                            <div class="form-group">
                                <label for="last_name">Last Name</label>
                                <input type="text" class="form-control" id="last_name" name="last_name" @if(checkDemo())
                                    value="<lastname>" @else value="{{ $user->last_name }}" @endif>
                            </div>
                            <div class="form-group">
                                <label for="role">Role</label>
                                <select class="form-control" id="role" name="role">
                                    <option value="">Select Role</option>
                                    <option value="user" {{ ($user->is_admin == 0) ? 'selected' : '' }}>User</option>
                                    <option value="admin" {{ ($user->is_admin == 1) ? 'selected' : '' }}>Admin</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="group">Group</label>
                                <select class="form-control" id="group" name="group" {{ ($user->isAdmin())
                                    ?'disabled':'' }}>
                                    <option value="">Select Group</option>
                                    @if(!is_null($user->group))
                                    @foreach ($groups as $group)
                                    <option value="{{ $group->group_ID }}" {{ ($user->group->group_ID ==
                                        $group->group_ID) ? 'selected' : '' }}>{{ $group->name }}</option>

                                    @endforeach
                                    @else
                                    @foreach ($groups as $group)
                                    <option value="{{ $group->group_ID }}">{{ $group->name }}</option>

                                    @endforeach

                                    @endif
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="status">Status</label>
                                <select class="form-control" id="status" name="status">
                                    <option value="">Select Status</option>
                                    <option value="active" {{ ($user->status === "Active") ? 'selected' : '' }}>Active
                                    </option>
                                    <option value="pended" {{ ($user->status === "Pended") ? 'selected' : '' }}>Pended
                                    </option>
                                    <option value="blocked" {{ ($user->status === "Blocked") ? 'selected' : ''
                                        }}>Blocked</option>
                                </select>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="modal-footer justify-content-center">
                    <div class="text-center">
                        <button type="button" id="saveBtn-edit-user" class="btn btn-primary mx-2 px-5 py-2">
                            Save
                        </button>
                        <button type="button" id="cancelBtn-edit-user" class="btn btn-light mx-2 px-5 py-2"
                            data-dismiss="modal">
                            Cancel
                        </button>
                        <div class="mt-3">
                            <div id="edit-user-confirm" class="alert bootstrap-alert-success mx-4 mb-3" role="alert"
                                style="display: none">
                            </div>
                            <div id="edit-user-error" class="alert bootstrap-alert-danger mx-4 mb-3" role="alert"
                                style="display: none">
                            </div>
                        </div>

                    </div>

                </div>
            </form>

        </div>
    </div>
</div>