@extends('layouts.app')


@section('content')



<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid px-4">
            <div class="row mt-2">
                <div class="col-sm-6">
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('scheduled-reports.index') }}">Scheduled
                                Reports</a></li>
                        <li class="breadcrumb-item">Add Scheduled Report</li>

                    </ol>
                </div>
            </div>
            <div class="row mb-2 mt-2">
                <div class="col-sm-8">
                    <h2><i class="fas fa-calendar-days"></i> Add Scheduled Report
                    </h2>
                </div>
            </div>

        </div>
        <div class="container-fluid mt-2 px-4">
            @if(session()->has('success'))
            <div class="alert alert-success">
                {!! session()->get('success') !!}
            </div>
            @endif

            @if(session()->has('failed'))
            <div class="alert alert-danger">
                {{ session()->get('failed') }}
            </div>
            @endif

            <form action="{{ route('scheduled-reports.store') }}" method="POST">
                @csrf
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title card-title-custom mb-0">Scheduled report Settings</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i
                                    class="fas fa-minus"></i></button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-12">
                                <label for="title" class="mt-2">Scheduled Report Title</label><i
                                    class="fa fa-question-circle" data-toggle="tooltip"
                                    data-title="Enter a title for this scheduled report."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                                <div>
                                    <input type="text"
                                        class="form-control {{ $errors->has('title') ? 'is-invalid' : ''}}" name="title"
                                        id="title" placeholder="title" value="{{ old('title') }}">
                                    @if($errors->has('title'))
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </div>
                                    @endif

                                </div>

                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-6">
                                <label for="begin-date" class="mt-2">Scheduled Report Begin date</label><i
                                    class="fa fa-question-circle" data-toggle="tooltip"
                                    data-title="Specify a start date for your scheduled report. This scheduled report will commence running from the selected date."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                                <div>
                                    <input type="date"
                                        class="form-control {{ $errors->has('begin_date') ? 'is-invalid' : ''}}"
                                        name="begin_date" id="begin-date" value="{{ old('begin_date') }}">
                                    @if($errors->has('begin_date'))
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('begin_date') }}</strong>
                                    </div>
                                    @endif

                                </div>
                            </div>
                            <div class="form-group col-6">
                                <label for="end-date" class="mt-2">Scheduled Report End date</label><i
                                    class="fa fa-question-circle" data-toggle="tooltip"
                                    data-title="Indicate an end date for your scheduled report. The scheduled report will continue running according to the specified frequency until the selected end date. After this date, its status will be marked as 'ended'."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                                <div>
                                    <input type="date"
                                        class="form-control {{ $errors->has('end_date') ? 'is-invalid' : ''}}"
                                        name="end_date" id="end-date" value="{{ old('end_date') }}">
                                    @if($errors->has('end_date'))
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('end_date') }}</strong>
                                    </div>
                                    @endif

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group
                            @if(old('frequency')=='hourly') {{ 'col-12' }}
                            @elseif(old('frequency')=='daily')
                            {{ 'col-6' }}
                            @elseif(in_array(old('frequency'),['weekly','monthly'])) {{ 'col-4' }}
                            @else
                            {{ 'col-12' }}
                            @endif
                                " id='frequency-container'>
                                <label for="frequency" class="mt-2">Sending Frequency</label><i
                                    class="fa fa-question-circle" data-toggle="tooltip"
                                    data-title="Specify how often you want to send the reports: Hourly, Daily, Weekly, or Monthly."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                                <div>
                                    <select class="form-control {{ $errors->has('frequency') ? 'is-invalid' : ''}}"
                                        name="frequency" id="frequency">
                                        <option value="">Please Choose Frequency</option>
                                        <option value="hourly" {{ old('frequency')=="hourly" ? 'selected' :'' }}>Hourly
                                        </option>
                                        <option value="daily" {{ old('frequency')=="daily" ? 'selected' :'' }}>Daily
                                        </option>
                                        <option value="weekly" {{ old('frequency')=="weekly" ? 'selected' :'' }}>Weekly
                                        </option>
                                        <option value="monthly" {{ old('frequency')=="monthly" ? 'selected' :'' }}>
                                            Monthly
                                        </option>
                                    </select>
                                    @if($errors->has('frequency'))
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('frequency') }}</strong>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group {{ is_null(old('frequency'))  || in_array(old('frequency'),['weekly','monthly']) ? 'col-4' :'col-6' }}"
                                style="{{ is_null(old('frequency'))  || old('frequency') == 'hourly' ? 'display:none' :'' }}"
                                id="sending-time">
                                <label class="mt-2">Sending time</label><i class="fa fa-question-circle"
                                    data-toggle="tooltip"
                                    data-title="Choose the specific time for sending the scheduled report according to its frequency."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                                <select class="form-control {{ $errors->has('sending_time') ? 'is-invalid' : ''}}"
                                    name="sending_time" id="time-daily">
                                    <option value="" {{ old('sending_time')=="" ? 'selected' :'' }}>Please
                                        Choose Hour</option>
                                    @foreach(range(0,23) as $hour)
                                    <option value="{{ $hour }}" {{ !is_null(old('sending_time')) &&
                                        old('sending_time')==$hour ? 'selected' :'' }}>{{ sprintf('%02d',
                                        $hour)}}:00</option>
                                    @endforeach
                                </select>
                                @if($errors->has('sending_time'))
                                <div class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('sending_time') }}</strong>
                                </div>
                                @endif
                            </div>
                            <div class="form-group col-4"
                                style="{{ is_null(old('frequency'))  || in_array(old('frequency'),['hourly','daily','monthly']) ? 'display:none' :'' }}"
                                id='sending-weekday'>
                                <label class="mt-2">Sending Weekday</label><i class="fa fa-question-circle"
                                    data-toggle="tooltip"
                                    data-title="Select the day of the week for sending weekly scheduled reports."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                                <select class="form-control {{ $errors->has('sending_weekly_day') ? 'is-invalid' : ''}}"
                                    name="sending_weekly_day" id="time-weekly">
                                    <option value="">Please Choose Day of week</option>
                                    <option value="monday" {{ old('sending_weekly_day')=="monday" ? 'selected' :'' }}>
                                        Monday</option>
                                    <option value="tuesday" {{ old('sending_weekly_day')=="tuesday" ? 'selected' :'' }}>
                                        Tuesday</option>
                                    <option value="wednesday" {{ old('sending_weekly_day')=="wednesday" ? 'selected' :''
                                        }}>Wednesday</option>
                                    <option value="thursday" {{ old('sending_weekly_day')=="thursday" ? 'selected' :''
                                        }}>Thursday</option>
                                    <option value="friday" {{ old('sending_weekly_day')=="friday" ? 'selected' :'' }}>
                                        Friday</option>
                                    <option value="saturday" {{ old('sending_weekly_day')=="saturday" ? 'selected' :''
                                        }}>Saturday</option>
                                    <option value="sunday" {{ old('sending_weekly_day')=="sunday" ? 'selected' :'' }}>
                                        Sunday</option>
                                </select>
                                @if($errors->has('sending_weekly_day'))
                                <div class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('sending_weekly_day') }}</strong>
                                </div>
                                @endif
                            </div>

                            <div class="form-group col-4"
                                style="{{ is_null(old('frequency'))  || in_array(old('frequency'),['hourly','daily','weekly']) ? 'display:none' :'' }}"
                                id="sending-monthday">
                                <label class="mt-2">Sending monthly day</label><i class="fa fa-question-circle"
                                    data-toggle="tooltip"
                                    data-title="Select the day of the month for sending monthly scheduled reports. Please note that you can opt for 'The last day of the month' if you wish your scheduled reports to be sent on the final day of each month, which varies depending on the month."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                                <select
                                    class="form-control {{ $errors->has('sending_monthly_day') ? 'is-invalid' : ''}}"
                                    name="sending_monthly_day" id="time-montly">
                                    <option value="">Please Choose Day of month</option>
                                    @foreach(range(1,28) as $day)
                                    <option value="{{ $day }}" {{ old('sending_monthly_day')==$day ? 'selected' :'' }}>
                                        {{ $day }}</option>
                                    @endforeach
                                    <option value="last" {{ old('sending_monthly_day')=='last' ? 'selected' :'' }}>
                                        The
                                        last day of the month</option>
                                </select>
                                @if($errors->has('sending_monthly_day'))
                                <div class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('sending_monthly_day') }}</strong>
                                </div>
                                @endif
                            </div>

                        </div>
                        <div class="row">
                            <div class="form-group col-6">
                                <label> Groups </label><i class="fa fa-question-circle" data-toggle="tooltip"
                                    data-title="Choose the groups to which you wish to send this report. All users within these selected groups will receive an email containing the reports whenever this scheduled report is executed."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                                <select multiple id="groups" name="groups[]"
                                    class="form-control {{ $errors->has('groups') ? 'is-invalid' : ''}}"
                                    style="overflow-y: auto">
                                    @foreach ($groups as $group)
                                    <option value="{{ $group->group_ID }}" {{ !is_null(old('groups')) &&
                                        in_array($group->
                                        group_ID, old('groups'))
                                        ? 'selected' :'' }}>{{
                                        $group->name }}</option>
                                    @endforeach
                                </select>
                                @if($errors->has('groups'))
                                <div class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('groups') }}</strong>
                                </div>
                                @endif

                            </div>
                            <div class="form-group col-6">
                                <label> Reports </label><i class="fa fa-question-circle" data-toggle="tooltip"
                                    data-title="Choose the report you wish to include in this scheduled report. Please note that the selected report will be attached as a PDF."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                                <select id="reports" name="report"
                                    class="form-control {{ $errors->has('report') ? 'is-invalid' : ''}}"
                                    style="overflow-y: auto">
                                    <option value="">Please Select Report</option>

                                    @foreach ($reports as $report)
                                    <option value="{{ $report->id }}" {{ old('report')==$report->id ? 'selected'
                                        :'' }}>{{ $report->name }}</option>
                                    @endforeach
                                </select>
                                @if($errors->has('report'))
                                <div class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('report') }}</strong>
                                </div>
                                @endif

                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group form-check col-6 ml-2">
                                <input type="checkbox" class="form-check-input" id="send-to-admins"
                                    name="send_to_admins" {{ !is_null(old('send_to_admins')) ? 'checked' :'' }}>
                                <label for="send-to-admins"> Send to Admins </label><i class="fa fa-question-circle"
                                    data-toggle="tooltip"
                                    data-title="If this checkbox is selected, the report will be sent to all system admins along with the users in the selected groups. Otherwise, it will only be sent to the admin who created it, in addition to the users in the selected groups."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title card-title-custom mb-0">Mail Settings</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i
                                    class="fas fa-minus"></i></button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-12">
                                <label for="sujbect" class="mt-2">Email Subject</label><i class="fa fa-question-circle"
                                    data-toggle="tooltip"
                                    data-title="Enter a subject for this scheduled report. Note that the subject of the email sent to users will match this entry."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                                <div>
                                    <input type="text"
                                        class="form-control {{ $errors->has('subject') ? 'is-invalid' : ''}}"
                                        name="subject" id="subject" placeholder="Email subject"
                                        value="{{ old('subject') }}">
                                    @if($errors->has('subject'))
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('subject') }}</strong>
                                    </div>
                                    @endif

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-12">
                                <label for="body" class="mt-2">Email Body</label><i class="fa fa-question-circle"
                                    data-toggle="tooltip"
                                    data-title="Compose an email body for this scheduled report. Keep in mind that the content of the email sent to users will correspond to this entry."
                                    style="color: #68b3c8; margin-left: 5px">
                                </i>
                                <div>
                                    <textarea type="text"
                                        class="form-control {{ $errors->has('body') ? 'is-invalid' : ''}}" name="body"
                                        id="body" placeholder="Email body" rows="3">{{ old('body') }}</textarea>
                                    @if($errors->has('body'))
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('body') }}</strong>
                                    </div>
                                    @endif

                                    <div class="mt-2">
                                        <a href="#" id="add-first-name">Personalize with user's first name</a> | <a
                                            href="#" id="add-email-signature">Personalize with
                                            email signature</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-2 col-12 mt-2">
                                <button type="submit" id="save-btn"
                                    class="btn btn-primary btn-block rounded-small">Save</button>
                            </div>
                            <div class="col-md-2 col-12 mt-2">
                                <button type="button" id="reset-btn"
                                    class="btn btn-secondary btn-block rounded-small">Reset</button>
                            </div>
                            <div class="col-md-2 col-12 mt-2">
                                <button type="button" id="close-btn" data-url="{{ route('scheduled-reports.index') }}"
                                    class="btn btn-secondary btn-block rounded-small">Close</button>
                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>

</div>


@endsection

@section('scripts')
@if(checkDemo() && !is_null(session()->get('demo')))
<script>
    $(`#demo-modal`).find('h5').text("{{ session()->get('demo') }}");
    $(`#demo-modal`).modal('show');
</script>
@endif

<script src="{{ get_asset('dist/js/scheduled-reports/add.js') }}" defer>
</script>
@endsection
