@extends('layouts.app')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid px-4">
            <div class="row mt-2">
                <div class="col-sm-6">
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('reports.index') }}">Reports</a></li>
                        <li class="breadcrumb-item">{{ $report->name }}</li>
                    </ol>
                </div>
            </div>
            <div class="row mb-2 mt-2">
                <div class="col-sm-8">
                    <h3>{{ $report->getResourceConfiguration('title') }}</h3>
                    <h6 class="created-at">{{ $report->created_at->format('d M Y h:i A') }}</h6>
                </div>
                <div class="col-sm-4 text-right">
                    <div class="p-2 branding-logo">

                        @if(is_null(getSettingsValue('system_logo')))
                        <img src="{{ get_asset('dist/images/srm-logo.jpg') }}" alt="Logo" class="brand-image" />
                        @else
                        <img src="{{ getSystemLogo() }}" alt="Logo" class="brand-image w-75" />
                        @endif
                    </div>

                </div>
            </div>
            <hr style="border-top: 1px solid rgba(0, 0, 0, .5);">

            <div class="mt-4" style="width: 100%">
                <iframe width="100%" style="height:85vh" id="display-blank-report-iframe" src="{{ $url }}"
                    frameborder="0"
                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                    allowfullscreen></iframe>
            </div>

        </div>


</div>


@endsection


@section('scripts')


@endsection
