<div class="modal fade" id="add-widget-modal" tabindex="-1" role="dialog" aria-labelledby="activate-user-modal"
    aria-modal="true">
    <div class="modal-dialog modal-dialog-centered  modal-lg" role="document">
        <div class="modal-content custom-rounded-edges">
            <div class="modal-header">
                <h5 class="modal-title ml-2" id="exampleModalLongTitle">
                    <i class="fa-solid fa-user mx-2"></i>
                    Add Widget
                </h5>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form method="POST" id="add-widget-form">
                <div class="modal-body mx-3 my-2">
                    <div class="modal-spinner" style="display: none"></div>
                    <div class="modal-container">
                        @if(checkDemo())
                        <div class="alert alert-info demo-alert text-sm">This demo dashboard is for demonstration
                            purposes only! Its
                            settings cannot be altered.
                        </div>
                        @endif

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="resource-type">Resource type</label>
                                    <select name="resource_types" id="resource-types" class="form-control">
                                        @foreach ($resourceTypes as $type)
                                        <option value="{{ $type['label'] }}">{{ $type['label'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6" style="{{ !is_null($widget->resource_id) ? 'display: none' :'' }}"
                                id="report-list-container">
                                <div class="form-group">
                                    <label for="resource">Report List title</label>
                                    <input class="form-control" name="title" id="report-list-title"
                                        value="{{ $widget->widget_title }}" />
                                </div>
                            </div>


                            <div class="col-md-6">

                                <div class="form-group">
                                    <label for="resource">Resource</label>
                                    <select class="form-control" id="resource"
                                        name="{{ is_null($widget->resource_id) ? 'resource[]':'resource' }}"
                                        @if(is_null($widget->resource_id)) {{ 'multiple' }} @endif>
                                        @if(!is_null($widget->resource_id))
                                        @foreach ($resources as $resource)
                                        <option value="{{ $resource->id }}">{{ $resource->name }}</option>
                                        @endforeach
                                        @else

                                        @foreach ($resources as $resource)
                                        <option value="{{ $resource->id }}" {{ collect($widget->
                                            report_lists)->contains('id',$resource->id) ?
                                            'selected'
                                            : ''}}>{{ $resource->name }}</option>
                                        @endforeach

                                        @endif
                                    </select>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="modal-footer justify-content-center">
                    <div class="text-center">
                        <button type="button" id="saveBtn-add-widget" class="btn btn-primary mx-2 px-5 py-2">
                            Save
                        </button>
                        <button type="button" id="cancelBtn-add-widget" class="btn btn-light mx-2 px-5 py-2"
                            data-dismiss="modal">
                            Cancel
                        </button>
                        <div class="mt-3">
                            <div id="add-widget-confirm" class="alert bootstrap-alert-success mx-4 mb-3" role="alert"
                                style="display: none">
                            </div>
                            <div id="add-widget-error" class="alert bootstrap-alert-danger mx-4 mb-3" role="alert"
                                style="display: none">
                            </div>
                        </div>

                    </div>

                </div>
            </form>

        </div>
    </div>
</div>
