@extends('layouts.auth')

@section('content')
<div class="container">
    <div class="modal fade login" id="loginModal">
        <div class="modal-dialog login animated">
            <div class="modal-content">

                <div class="modal-body">
                    <div class="box">
                        <div class="content">

                            <div class="form loginBox">
                                <div style="margin: 5px;"><img src="{{ get_asset('dist/auth/img/srm-logo.jpg')}}"
                                        width="100%" /></div>

                                <form method="post" id="login-form" action="{{ route('login') }}"
                                    accept-charset="UTF-8">
                                    @csrf
                                    <input id="email" class="form-control" type="text" placeholder="Email" name="email"
                                        @if(checkDemo()) value="demo@mysqlreports.com" @else value="{{ old('email') }}"
                                        @endif>
                                    <input id="password" class="form-control" type="password" placeholder="Password"
                                        name="password" @if(checkDemo()) value="TrialPass2025!" @endif>

                                    <input class="btn btn-default btn-login" type="submit" value="Login">
                                    @if(!checkDemo())
                                    <input name="remember" type="checkbox" id="remember">
                                    <span for="remember">
                                        Remember Me
                                    </span>
                                    @endif
                                    @include('partials._errors')
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                @if(!checkDemo())
                <div class="modal-footer">
                    <div class="forgot login-footer">

                        @if (\App\Http\Controllers\Auth\AuthHelpers::checkRegister())
                        <span>Looking to
                            <a href="{{ route('register') }}">create an account</a>
                            ? <br> or <br> <a href="{{ route('password.request') }}">Forgot
                                Password</a></span>
                        @else
                        <span>
                            <a href="{{ route('password.request') }}">Forgot Password</a></span>

                        @endif
                    </div>
                    @endif

                    <div class="forgot forgot-footer" style="display:none">

                        <a href="javascript: showLoginForm();">Login</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="{{ get_asset('dist/auth/js/jquery-1.10.2.js')}}" type="text/javascript"></script>
<script src="{{ get_asset('dist/auth/js/bootstrap.js')}}" type="text/javascript"></script>
<script src="{{ get_asset('dist/auth/js/login-register.js')}}" type="text/javascript"></script>
<script>
    $(document).ready(function(){

$('.big-login').trigger('click');
})

</script>
@endsection
