<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of access_control_abstract
 *
 * @author memad
 */
abstract class access_control_abstract implements Access_control_interface
{
    protected $user_session;
    protected $user_saved_user_id;
    protected $user_Saved_email;
    protected $user_saved_group;
    protected $user_saved_role;
    protected $user_saved_ip;
    protected $user_saved_agnet;
    protected $user__saved_username;
    protected $dashboard;

    public function validate_access_to_wizard()
    {
        $report_creator = isset($_SESSION[Session_security_key][srm_access_userid]) ? intval($_SESSION[Session_security_key][srm_access_userid]) : '';

        if (!empty($this->user_session)) {
            $this->fill_user_saved_details($this->user_session);

// if ($this->check_session_keys() && $this->check_session_formats() && $this->check_saved_ip() && $this->check_saved_agent()) {
            if ($this->check_session_keys() && $this->check_session_formats()) {
                if ($this->check_group_access_wizard()) {
                    return true;
                } elseif ($_SESSION[Session_wizard_key]["edit_mode"] && $report_creator === $_SESSION[Session_wizard_key]["report_id"]) {
                    return true;
                } else {
                    $this->redirectToLogin("group not allowing");
                }

            } else {
                $this->redirectToLogin();
            }

        } else {
            $this->redirectToLogin("session is empty");
        }

    }

    public function validate_access_to_report($resource)
    {
        $dashboard_connection = new DatabaseHandler(DEFAULT_HOST, DEFAULT_DBUSER, DEFAULT_DBPASS, DEFAULT_DBNAME);
        $reader               = new Reader(tables_prefix . table_settings, $dashboard_connection);

        $sharedKey        = $reader->filter_by_column('settings_key', 'shared_key')[0]['settings_value'];
        $requestSharedKey = $_SERVER['HTTP_INTERNAL_KEY'];

        if (strtolower($this->get_resource_type($resource)) === strtolower(public_report) || (isset($requestSharedKey) && $sharedKey == $requestSharedKey)) {
            return true;
        } else {
            if (!empty($this->user_session)) {
                $this->fill_user_saved_details($this->user_session);

// if ($this->check_session_keys() && $this->check_session_formats() && $this->check_saved_ip() && $this->check_saved_agent()) {
                if ($this->check_session_keys() && $this->check_session_formats()) {
                    if ($this->check_group_access_resource($resource)) {
                        return true;
                    } else {
                        $this->redirectToLogin("FORBIDDEN Access. group not allowing");
                    }

                } else {
                    $this->redirectToLogin("session keys not valid");
                }

            } else {
                $this->redirectToLogin("empty user session");
            }

        }

    }

    protected function check_session_keys()
    {

        foreach (srm_access_session_array_keys as $key) {
            if (!array_key_exists($key, $this->user_session)) {
                srm_dashboard::log("FORBIDDEN Access. Session keys security error.");
                return false;
            }

        }

        return true;
    }

    /**
     * check that session saved IP matches user's current IP
     */
    protected function check_saved_ip()
    {

        if ($this->user_saved_ip != $_SERVER['REMOTE_ADDR']) {
            srm_dashboard::log("Ip access issue saved IP in session " . $this->user_saved_ip . " while actual IP of user" . $_SERVER['REMOTE_ADDR']);
            return false;
        } else {
            return true;
        }

    }

    /**
     * check that session saved user agent matches user's current user agent
     */
    protected function check_saved_agent()
    {

        if ($this->user_saved_agnet != $_SERVER['HTTP_USER_AGENT']) {
            srm_dashboard::log("user agent saved agent in session " . $this->user_saved_agnet . " while actual agent of user" . $_SERVER['HTTP_USER_AGENT']);
            return false;
        } else {
            return true;
        }

    }

    /**
     * redirect user to login if not empty
     */
    protected function redirectToLogin($reason = "not set", $redirect = "403")
    {

        if ($redirect == "403") {
            header('HTTP/1.1 403 FORBIDDEN');
            header('Status: 403 You Do Not Have Access To This Page');
            exit();
        } else {
            header("Location: " . srm_redirect_login_page_url);
            exit();
        }

    }

    /**
     * validate user's session
     */
    protected function check_session_formats()
    {
        return true;
    }

    /**
     * fill user details from session
     */
    protected function fill_user_saved_details($array)
    {

// $this->user_saved_ip = isset($array[srm_access_ip]) ? $array[srm_access_ip] : "";
        // $this->user_saved_agnet = isset($array[srm_access_user_agent]) ? $array[srm_access_user_agent] : "";
        $this->user_saved_group     = isset($array[srm_access_group]) ? $array[srm_access_group] : "";
        $this->user_saved_role      = isset($array[srm_access_role]) ? $array[srm_access_role] : "";
        $this->user_Saved_email     = isset($array[srm_access_email]) ? $array[srm_access_email] : "";
        $this->user_saved_user_id   = isset($array[srm_access_userid]) ? $array[srm_access_userid] : "";
        $this->user__saved_username = isset($array[srm_access_username]) ? $array[srm_access_username] : "";
    }

}