# Smart Report Maker
## 1. Install dockerized version
### 1.1 Simplest Method
### 1.1.1 Configure aws and pull image
1. Configure aws with the command `aws configure`.
2. Enter `AWS Access Key ID`, `AWS Secret Access Key` and `region name`
  - note region is `us-east-1`.
3. login to ECR with the below command:<br />
`aws ecr get-login-password --region us-east-1 | docker login --username AWS --password-stdin 905418272375.dkr.ecr.us-east-1.amazonaws.com/srm`<br />
4. Pull the image from ECR: <br/>
`docker pull 905418272375.dkr.ecr.us-east-1.amazonaws.com/srm:v9.1.10`

### 1.1.2 Run the container
1. Run the container with the below command<br/>
`docker run -d -v srm_volume_config:/var/www/html/dashboard/config -v  srm_volume_reports:/var/www/html/modules/SRM9/SRM/Reports9 --add-host=host.docker.internal:host-gateway --name srm -p 8000:80 905418272375.dkr.ecr.us-east-1.amazonaws.com/srm:v9.1.10`

### 1.2 Advanced Method (Docker compose)
  please edit `.docker-env` file to set `IMAGE_TAG`, `MYSQL_DATABASE` and `MYSQL_ROOT_PASSWORD` environemnt variables.<br/>
### 1.2.1 Run only SRM from ECR<br/>
`docker compose --env-file .docker-env -f "docker-compose-first.yml" up`
  
### 1.2.2 Run SRM from ECR and mysql <br/>
`docker compose --env-file .docker-env -f "docker-compose-second.yml" up`

