@extends('layouts.app')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Profile</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                    <li class="breadcrumb-item active">Profile</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-6">
                <div class="card bg-white">
                    <div class="card-header">
                        <div class="d-flex justify-content-between">
                            <h3 class="card-title">Organization details</h3>
                        </div>
                    </div>
                    <form>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="organizationInputName">Organization Name</label>
                                <div class="d-flex">
                                    <input type="text" class="form-control" id="organizationInputName"
                                        placeholder="Organization Name" />
                                    <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                        data-placement="top" title="Tooltip on top">
                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="organizationContactInformation">Organization Contact
                                    Information</label>
                                <div class="d-flex">
                                    <textarea class="form-control" id="organizationContactInformation" rows="2"
                                        placeholder="Organization Contact Information"></textarea>
                                    <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                        data-placement="top" title="Tooltip on top">
                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="logo">Logo</label>
                                <div class="input-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="logo">
                                        <label class="custom-file-label" for="logo">Choose file</label>
                                    </div>
                                    <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                        data-placement="top" title="Tooltip on top">
                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="taxInfo">Tax Info</label>
                                <div class="d-flex">
                                    <textarea class="form-control" id="taxInfo" rows="2"
                                        placeholder="Tax Info"></textarea>
                                    <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                        data-placement="top" title="Tooltip on top">
                                        <i class="fa-solid fa-circle-question"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="text-center">
                                <button class="btn btn-primary mx-2 px-5 py-2">Save</button>
                                <button class="btn btn-secondary mx-2 px-5 py-2">Cancel</button>
                            </div>
                            <div class="alert bootstrap-alert-danger my-2" role="alert">
                                Error Message
                            </div>

                        </div>
                    </form>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card bg-white">
                    <div class="card-header">
                        <div class="d-flex justify-content-between">
                            <h3 class="card-title">Contact and Login details</h3>
                        </div>
                    </div>
                    <form>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="userName">User Name</label>
                                <input type="text" class="form-control" id="userName" placeholder="User Name" />
                            </div>
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" class="form-control" id="email" placeholder="Email" />
                            </div>

                            <div class="form-group">
                                <label for="securityQuestion">Security Question</label>
                                <select class="form-control" id="securityQuestion">
                                    <option>1</option>
                                    <option>2</option>
                                    <option>3</option>
                                    <option>4</option>
                                    <option>5</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="answer">Answer</label>
                                <input type="text" class="form-control" id="answer" placeholder="Answer" />
                            </div>
                            <div class="form-group">
                                <label for="password">Password</label>
                                <input type="password" class="form-control" id="password" placeholder="Password" />
                            </div>
                            <div class="form-group">
                                <label for="confirmPassword">Confirm Password</label>
                                <input type="password" class="form-control" id="confirmPassword"
                                    placeholder="Confirm Password" />
                            </div>
                            <div class="form-group">
                                <label for="contactName">Contact Name</label>
                                <input type="text" class="form-control" id="contactName" placeholder="Contact Name" />
                            </div>
                            <div class="form-group">
                                <label for="phone">Phone</label>
                                <input type="tel" class="form-control" id="phone" placeholder="Phone" />
                            </div>
                            <div class="text-center">
                                <button class="btn btn-primary mx-2 px-5 py-2">Save</button>
                                <button class="btn btn-secondary mx-2 px-5 py-2">Cancel</button>
                            </div>

                            <div class="alert bootstrap-alert-success my-2" role="alert">
                                Confirmation Message
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection