@extends('layouts.bootstrap3')
@section('styles')

<link href="{{ get_asset('dist/css/paper-bootstrap-wizard.css') }}" rel="stylesheet">
<link rel="stylesheet" href="{{ get_asset('dist/css/charts.css') }}">

<link href="{{ get_asset('dist/css/themify-icons.css')}}" rel="stylesheet">
<link href="{{ get_asset('dist/css/fontawesome.min.css')}}" rel="stylesheet">

@if(checkDemo())
<link href="{{ get_asset('dist/css/alertify.core.css')}}" rel="stylesheet">
<link href="{{ get_asset('dist/css/alertify.default.css')}}" rel="stylesheet">
@endif

@endsection

@section('content')
@include('dashboard.metrics.partials.confirm-public')
<div id="global-loader">
    <img src="{{get_asset('dist/images/loader.gif')}}" class="loader-img" alt="Loader">
    <div class="loader-text"></div>

</div>

<div>
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <!--      Wizard container        -->
                <div class="wizard-container">
                    <div class="card wizard-card" data-color="blue" id="wizard"
                        style="box-shadow:0 0 0 0 rgba(0, 0, 0, 0.57);margin-bottom: 0px;padding:0">
                        <!--        You can switch " data-color="green" "  with one of the next bright colors: "blue", "azure", "orange", "red"       -->
                        <div class="wizard-navigation">
                            <div class="progress-with-circle">
                                <div class="progress-bar" role="progressbar" aria-valuenow="1" aria-valuemin="1"
                                    aria-valuemax="4" style="width: 10%"></div>
                            </div>
                            <ul class="steps nav nav-pills" id="tabs">
                                <li id="database" class="" style="width: 20%">
                                    <a href="#type" data-toggle="tab" aria-expanded="false">
                                        <div class="icon-circle checked">
                                            <i class="ti-brush"></i>
                                        </div>
                                        Appearnce
                                    </a>
                                </li>

                                <li id="database" class="" style="width: 20%">
                                    <a href="#setup" data-toggle="tab" aria-expanded="false">
                                        <div class="icon-circle checked">
                                            <i class="ti-settings"></i>
                                        </div>
                                        Settings
                                    </a>
                                </li>
                                <li style="width: 20%">
                                    <a href="#data" data-toggle="tab">
                                        <div class="icon-circle">
                                            <i class="ti-server"></i>
                                        </div>
                                        Data
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="tab-content" style="padding:105px 20px 0px">
                            @if(checkDemo())
                            <div class="alert alert-info">This demo metric is for demonstration purposes only! Its
                                settings cannot be altered.
                            </div>
                            @endif

                            <div class="tab-pane" id="type">
                                <div class="row"></div>
                                <form action="#" id="metric-type-form"
                                    data-url="{{ route('metrics.wizard.appearance.store') }}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <h5 style="color: #67b0ca;margin-bottom:0">
                                                    <b>Metric Type</b>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="This field allows you to select the display format for your Metric / KPI. You can choose either to display the metric as a numeric value within an info box, a numeric value accompanied by an icon (to visually represent the meaning of the indicator) in an info box, or visualize the metric using a gauge chart."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>

                                                </h5>

                                                <div class="text-center">
                                                    @foreach (array_chunk($metricsTypes, 3) as $metrics_chunk)
                                                    <div class="row">
                                                        @foreach ($metrics_chunk as $type)
                                                        <div class="col-sm-4" style="margin-bottom: 0">
                                                            <label class="metric-container"
                                                                for="{{ $type['value'] }}Radio">
                                                                <img src="{{ get_asset('dist/images/' .
                                                                    $type['image'])}}" width="90%" alt="metric" />
                                                            </label>
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="{{ $type['value'] }}Radio"
                                                                    name="metric_type" value="{{ $type['value'] }}"
                                                                    @if($metric->configurations->chart_type ==
                                                                $type['value'])
                                                                checked
                                                                @endif
                                                                class="custom-control-input" />
                                                                <label class="custom-control-label"
                                                                    for="{{ $type['value'] }}Radio">{{$type['label']}}</label>
                                                            </div>
                                                        </div>
                                                        @endforeach

                                                    </div>
                                                    @endforeach

                                                    <div class="col-sm-5" id="metric-color-drop-menu"
                                                        style="margin-top: 10px;text-align:left; @if($metric->configurations->chart_type == 'gauge_chart') visibility:hidden @endif">
                                                        <h5 style="color: #67b0ca">
                                                            <b>Metric Color </b>
                                                            <span class="glyphicon glyphicon-info-sign"
                                                                data-toggle="tooltip"
                                                                data-title="This color will serve as either the background color of the info box or the color of the gauge chart."
                                                                style="color: #68b3c8; margin-left: 5px">
                                                            </span>
                                                        </h5>
                                                        <div class="form-group">
                                                            <select class="form-control" id="metricColor"
                                                                name="metric_color">
                                                                <option value="">Please Choose Metric color</option>
                                                                @foreach ($colors as $color)
                                                                <option value="{{ $color }}" @if($metric->metric_color
                                                                    == $color) {{ "selected" }} @endif>{{
                                                                    ucfirst($color) }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="col-sm-5"
                                                        style="margin-top: 10px;text-align:left;@if($metric->configurations->chart_type != 'info_box_with_icon') {{ "
                                                        display:none" }}@endif" id="info-box-icon-drop-menu">
                                                        <h5 style="color: #67b0ca">
                                                            <b>Info Box icon</b>
                                                            <span class="glyphicon glyphicon-info-sign"
                                                                data-toggle="tooltip"
                                                                data-title="Select an icon that represents the meaning of the Metric. This icon will be displayed alongside the metric value in the info box."
                                                                style="color: #68b3c8; margin-left: 5px">
                                                            </span>
                                                        </h5>
                                                        <div class="form-group">
                                                            <select class="form-control" id="info-box-icon"
                                                                name="info_box_icon" style="font-family: 'FontAwesome'">

                                                                <option value="">Please Choose icon</option>
                                                                <option value="#xf036;" {{ $metric->info_box_icon ===
                                                                    "#xf036;" ? 'selected':''}}>&#xf036; </option>
                                                                <option value="#xf038;" {{ $metric->info_box_icon ===
                                                                    "#xf038;" ? 'selected':''}}>&#xf038; </option>
                                                                <option value="#xf270;" {{ $metric->info_box_icon ===
                                                                    "#xf270;" ? 'selected':''}}>&#xf270; </option>
                                                                <option value="#xf0f9;" {{ $metric->info_box_icon ===
                                                                    "#xf0f9;" ? 'selected':''}}>&#xf0f9; </option>
                                                                <option value="#xf13d;" {{ $metric->info_box_icon ===
                                                                    "#xf0f9;" ? 'selected':''}}>&#xf0f9; </option>
                                                                <option value="#xf17b;" {{ $metric->info_box_icon ===
                                                                    "#xf17b;" ? 'selected':''}}>&#xf17b; </option>
                                                                <option value="#xf209;" {{ $metric->info_box_icon ===
                                                                    "#xf209;" ? 'selected':''}}>&#xf209; </option>
                                                                <option value="#xf103;" {{ $metric->info_box_icon ===
                                                                    "#xf103;" ? 'selected':''}}>&#xf103; </option>
                                                                <option value="#xf100;" {{ $metric->info_box_icon ===
                                                                    "#xf100;" ? 'selected':''}}>&#xf100; </option>
                                                                <option value="#xf101;" {{ $metric->info_box_icon ===
                                                                    "#xf101;" ? 'selected':''}}>&#xf101; </option>
                                                                <option value="#xf102;" {{ $metric->info_box_icon ===
                                                                    "#xf102;" ? 'selected':''}}>&#xf102; </option>
                                                                <option value="#xf104;" {{ $metric->info_box_icon ===
                                                                    "#xf104;" ? 'selected':''}}>&#xf104; </option>
                                                                <option value="#xf105;" {{ $metric->info_box_icon ===
                                                                    "#xf105;" ? 'selected':''}}>&#xf105; </option>
                                                                <option value="#xf106;" {{ $metric->info_box_icon ===
                                                                    "#xf106;" ? 'selected':''}}>&#xf106; </option>
                                                                <option value="#xf179;" {{ $metric->info_box_icon ===
                                                                    "#xf179;" ? 'selected':''}}>&#xf179; </option>
                                                                <option value="#xf187;" {{ $metric->info_box_icon ===
                                                                    "#xf187;" ? 'selected':''}}>&#xf187; </option>
                                                                <option value="#xf1fe;" {{ $metric->info_box_icon ===
                                                                    "#xf1fe;" ? 'selected':''}}>&#xf1fe; </option>
                                                                <option value="#xf0ab;" {{ $metric->info_box_icon ===
                                                                    "#xf0ab;" ? 'selected':''}}>&#xf0ab;</option>
                                                                <option value="#xf0a8;" {{ $metric->info_box_icon ===
                                                                    "#xf0a8;" ? 'selected':''}}>&#xf0a8;</option>
                                                                <option value="#xf01a;" {{ $metric->info_box_icon ===
                                                                    "#xf01a;" ? 'selected':''}}>&#xf01a;</option>
                                                                <option value="#xf190;" {{ $metric->info_box_icon ===
                                                                    "#xf190;" ? 'selected':''}}>&#xf190;</option>
                                                                <option value="#xf18e;" {{ $metric->info_box_icon ===
                                                                    "#xf18e;" ? 'selected':''}} >&#xf18e;</option>
                                                                <option value="#xf01b;" {{ $metric->info_box_icon ===
                                                                    "#xf01b;" ? 'selected':''}}>&#xf01b;</option>
                                                                <option value="#xf0a9;" {{ $metric->info_box_icon ===
                                                                    "#xf0a9;" ? 'selected':''}}>&#xf0a9;</option>
                                                                <option value="#xf0aa;" {{ $metric->info_box_icon ===
                                                                    "#xf0aa;" ? 'selected':''}}>&#xf0aa;</option>
                                                                <option value="#xf063;" {{ $metric->info_box_icon ===
                                                                    "#xf063;" ? 'selected':''}}>&#xf063; </option>
                                                                <option value="#xf060;" {{ $metric->info_box_icon ===
                                                                    "#xf060;" ? 'selected':''}}>&#xf060; </option>
                                                                <option value="#xf061;" {{ $metric->info_box_icon ===
                                                                    "#xf061;" ? 'selected':''}}>&#xf061; </option>
                                                                <option value="#xf062;" {{ $metric->info_box_icon ===
                                                                    "#xf062;" ? 'selected':''}}>&#xf062; </option>
                                                                <option value="#xf047;" {{ $metric->info_box_icon ===
                                                                    "#xf047;" ? 'selected':''}}>&#xf047; </option>
                                                                <option value="#xf0b2;" {{ $metric->info_box_icon ===
                                                                    "#xf0b2;" ? 'selected':''}}>&#xf0b2; </option>
                                                                <option value="#xf07e;" {{ $metric->info_box_icon ===
                                                                    "#xf07e;" ? 'selected':''}}>&#xf07e; </option>
                                                                <option value="#xf07d;" {{ $metric->info_box_icon ===
                                                                    "#xf07d;" ? 'selected':''}}>&#xf07d; </option>
                                                                <option value="#xf069;" {{ $metric->info_box_icon ===
                                                                    "#xf069;" ? 'selected':''}}>&#xf069; </option>
                                                                <option value="#xf1fa;" {{ $metric->info_box_icon ===
                                                                    "#xf1fa;" ? 'selected':''}}>&#xf1fa; </option>
                                                                <option value="#xf1b9;" {{ $metric->info_box_icon ===
                                                                    "#xf1b9;" ? 'selected':''}}>&#xf1b9; </option>
                                                                <option value="#xf04a;" {{ $metric->info_box_icon ===
                                                                    "#xf04a;" ? 'selected':''}}>&#xf04a; </option>
                                                                <option value="#xf24e;" {{ $metric->info_box_icon ===
                                                                    "#xf24e;" ? 'selected':''}}>&#xf24e; </option>
                                                                <option value="#xf05e;" {{ $metric->info_box_icon ===
                                                                    "#xf05e;" ? 'selected':''}}>&#xf05e; </option>
                                                                <option value="#xf19c;" {{ $metric->info_box_icon ===
                                                                    "#xf19c;" ? 'selected':''}}>&#xf19c; </option>
                                                                <option value="#xf080;" {{ $metric->info_box_icon ===
                                                                    "#xf080;" ? 'selected':''}}>&#xf080; </option>
                                                                <option value="#xf080;" {{ $metric->info_box_icon ===
                                                                    "#xf080;" ? 'selected':''}}>&#xf080; </option>
                                                                <option value="#xf240;" {{ $metric->info_box_icon ===
                                                                    "#xf240;" ? 'selected':''}}>&#xf240; </option>
                                                                <option value="#xf0fc;" {{ $metric->info_box_icon ===
                                                                    "#xf0fc;" ? 'selected':''}}>&#xf0fc; </option>
                                                                <option value="#xf1b4;" {{ $metric->info_box_icon ===
                                                                    "#xf1b4;" ? 'selected':''}}>&#xf1b4; </option>
                                                                <option value="#xf1b5;" {{ $metric->info_box_icon ===
                                                                    "#xf1b5;" ? 'selected':''}}>&#xf1b5; </option>
                                                                <option value="#xf0f3;" {{ $metric->info_box_icon ===
                                                                    "#xf0f3;" ? 'selected':''}}>&#xf0f3; </option>
                                                                <option value="#xf0a2;" {{ $metric->info_box_icon ===
                                                                    "#xf0a2;" ? 'selected':''}}>&#xf0a2; </option>
                                                                <option value="#xf1f6;" {{ $metric->info_box_icon ===
                                                                    "#xf1f6;" ? 'selected':''}}>&#xf1f6; </option>
                                                                <option value="#xf1f7;" {{ $metric->info_box_icon ===
                                                                    "#xf1f7;" ? 'selected':''}}>&#xf1f7; </option>
                                                                <option value="#xf206;" {{ $metric->info_box_icon ===
                                                                    "#xf206;" ? 'selected':''}}>&#xf206; </option>
                                                                <option value="#xf1e5;" {{ $metric->info_box_icon ===
                                                                    "#xf1e5;" ? 'selected':''}}>&#xf1e5; </option>
                                                                <option value="#xf1fd;" {{ $metric->info_box_icon ===
                                                                    "#xf1fd;" ? 'selected':''}}>&#xf1fd; </option>
                                                                <option value="#xf171;" {{ $metric->info_box_icon ===
                                                                    "#xf171;" ? 'selected':''}}>&#xf171; </option>
                                                                <option value="#xf172;" {{ $metric->info_box_icon ===
                                                                    "#xf172;" ? 'selected':''}}>&#xf172;</option>
                                                                <option value="#xf15a;" {{ $metric->info_box_icon ===
                                                                    "#xf15a;" ? 'selected':''}}>&#xf15a; </option>
                                                                <option value="#xf27e;" {{ $metric->info_box_icon ===
                                                                    "#xf27e;" ? 'selected':''}}>&#xf27e; </option>
                                                                <option value="#xf032;" {{ $metric->info_box_icon ===
                                                                    "#xf032;" ? 'selected':''}}>&#xf032; </option>
                                                                <option value="#xf0e7;" {{ $metric->info_box_icon ===
                                                                    "#xf0e7;" ? 'selected':''}}>&#xf0e7; </option>
                                                                <option value="#xf1e2;" {{ $metric->info_box_icon ===
                                                                    "#xf1e2;" ? 'selected':''}}>&#xf1e2; </option>
                                                                <option value="#xf02d;" {{ $metric->info_box_icon ===
                                                                    "#xf02d;" ? 'selected':''}}>&#xf02d; </option>
                                                                <option value="#xf02e;" {{ $metric->info_box_icon ===
                                                                    "#xf02e;" ? 'selected':''}}>&#xf02e; </option>
                                                                <option value="#xf097;" {{ $metric->info_box_icon ===
                                                                    "#xf097;" ? 'selected':''}}>&#xf097; </option>
                                                                <option value="#xf0b1;" {{ $metric->info_box_icon ===
                                                                    "#xf0b1;" ? 'selected':''}}>&#xf0b1; </option>
                                                                <option value="#xf15a;" {{ $metric->info_box_icon ===
                                                                    "#xf15a;" ? 'selected':''}}>&#xf15a; </option>
                                                                <option value="#xf188;" {{ $metric->info_box_icon ===
                                                                    "#xf188;" ? 'selected':''}}>&#xf188; </option>
                                                                <option value="#xf1ad;" {{ $metric->info_box_icon ===
                                                                    "#xf1ad;" ? 'selected':''}}>&#xf1ad; </option>
                                                                <option value="#xf0f7;" {{ $metric->info_box_icon ===
                                                                    "#xf0f7;" ? 'selected':''}}>&#xf0f7; </option>
                                                                <option value="#xf0a1;" {{ $metric->info_box_icon ===
                                                                    "#xf0a1;" ? 'selected':''}}>&#xf0a1; </option>
                                                                <option value="#xf140;" {{ $metric->info_box_icon ===
                                                                    "#xf140;" ? 'selected':''}}>&#xf140; </option>
                                                                <option value="#xf207;" {{ $metric->info_box_icon ===
                                                                    "#xf207;" ? 'selected':''}}>&#xf207; </option>
                                                                <option value="#xf1ba;" {{ $metric->info_box_icon ===
                                                                    "#xf1ba;" ? 'selected':''}}>&#xf1ba; </option>
                                                                <option value="#xf073;" {{ $metric->info_box_icon ===
                                                                    "#xf073;" ? 'selected':''}}>&#xf073; </option>
                                                                <option value="#xf030;" {{ $metric->info_box_icon ===
                                                                    "#xf030;" ? 'selected':''}}>&#xf030; </option>
                                                                <option value="#xf1b9;" {{ $metric->info_box_icon ===
                                                                    "#xf1b9;" ? 'selected':''}}>&#xf1b9; </option>
                                                                <option value="#xf0d8;" {{ $metric->info_box_icon ===
                                                                    "#xf0d8;" ? 'selected':''}}>&#xf0d8; </option>
                                                                <option value="#xf217;" {{ $metric->info_box_icon ===
                                                                    "#xf217;" ? 'selected':''}}>&#xf217; </option>
                                                                <option value="#xf20a;" {{ $metric->info_box_icon ===
                                                                    "#xf20a;" ? 'selected':''}}>&#xf20a; </option>
                                                                <option value="#xf1f3;" {{ $metric->info_box_icon ===
                                                                    "#xf1f3;" ? 'selected':''}}>&#xf1f3; </option>
                                                                <option value="#xf24b;" {{ $metric->info_box_icon ===
                                                                    "#xf24b;" ? 'selected':''}}>&#xf24b; </option>
                                                                <option value="#xf1f4;" {{ $metric->info_box_icon ===
                                                                    "#xf1f4;" ? 'selected':''}}>&#xf1f4; </option>
                                                                <option value="#xf1f5;" {{ $metric->info_box_icon ===
                                                                    "#xf1f5;" ? 'selected':''}}>&#xf1f5; </option>
                                                                <option value="#xf1f0;" {{ $metric->info_box_icon ===
                                                                    "#xf1f0;" ? 'selected':''}}>&#xf1f0; </option>
                                                                <option value="#xf0c1;" {{ $metric->info_box_icon ===
                                                                    "#xf0c1;" ? 'selected':''}}>&#xf0c1; </option>
                                                                <option value="#xf00c;" {{ $metric->info_box_icon ===
                                                                    "#xf00c;" ? 'selected':''}}>&#xf00c; </option>
                                                                <option value="#xf053;" {{ $metric->info_box_icon ===
                                                                    "#xf053;" ? 'selected':''}}>&#xf053; </option>
                                                                <option value="#xf054;" {{ $metric->info_box_icon ===
                                                                    "#xf054;" ? 'selected':''}}>&#xf054; </option>
                                                                <option value="#xf077;" {{ $metric->info_box_icon ===
                                                                    "#xf077;" ? 'selected':''}}>&#xf077; </option>
                                                                <option value="#xf1ae;" {{ $metric->info_box_icon ===
                                                                    "#xf1ae;" ? 'selected':''}}>&#xf1ae; </option>
                                                                <option value="#xf268;" {{ $metric->info_box_icon ===
                                                                    "#xf268;" ? 'selected':''}}>&#xf268; </option>
                                                                <option value="#xf111;" {{ $metric->info_box_icon ===
                                                                    "#xf111;" ? 'selected':''}}>&#xf111; </option>
                                                                <option value="#xf10c;" {{ $metric->info_box_icon ===
                                                                    "#xf10c;" ? 'selected':''}}>&#xf10c; </option>
                                                                <option value="#xf1ce;" {{ $metric->info_box_icon ===
                                                                    "#xf1ce;" ? 'selected':''}}>&#xf1ce; </option>
                                                                <option value="#xf1db;" {{ $metric->info_box_icon ===
                                                                    "#xf1db;" ? 'selected':''}}>&#xf1db; </option>
                                                                <option value="#xf0ea;" {{ $metric->info_box_icon ===
                                                                    "#xf0ea;" ? 'selected':''}}>&#xf0ea; </option>
                                                                <option value="#xf017;" {{ $metric->info_box_icon ===
                                                                    "#xf017;" ? 'selected':''}}>&#xf017; </option>
                                                                <option value="#xf24d;" {{ $metric->info_box_icon ===
                                                                    "#xf24d;" ? 'selected':''}}>&#xf24d; </option>
                                                                <option value="#xf00d;" {{ $metric->info_box_icon ===
                                                                    "#xf00d;" ? 'selected':''}}>&#xf00d; </option>
                                                                <option value="#xf0c2;" {{ $metric->info_box_icon ===
                                                                    "#xf0c2;" ? 'selected':''}}>&#xf0c2; </option>
                                                                <option value="#xf0ed;" {{ $metric->info_box_icon ===
                                                                    "#xf0ed;" ? 'selected':''}}>&#xf0ed; </option>
                                                                <option value="#xf0ee;" {{ $metric->info_box_icon ===
                                                                    "#xf0ee;" ? 'selected':''}}>&#xf0ee; </option>
                                                                <option value="#xf157;" {{ $metric->info_box_icon ===
                                                                    "#xf157;" ? 'selected':''}}>&#xf157; </option>
                                                                <option value="#xf121;" {{ $metric->info_box_icon ===
                                                                    "#xf121;" ? 'selected':''}}>&#xf121; </option>
                                                                <option value="#xf126;" {{ $metric->info_box_icon ===
                                                                    "#xf126;" ? 'selected':''}}>&#xf126; </option>
                                                                <option value="#xf1cb;" {{ $metric->info_box_icon ===
                                                                    "#xf1cb;" ? 'selected':''}}>&#xf1cb; </option>
                                                                <option value="#xf0f4;" {{ $metric->info_box_icon ===
                                                                    "#xf0f4;" ? 'selected':''}}>&#xf0f4; </option>
                                                                <option value="#xf013;" {{ $metric->info_box_icon ===
                                                                    "#xf013;" ? 'selected':''}}>&#xf013; </option>
                                                                <option value="#xf085;" {{ $metric->info_box_icon ===
                                                                    "#xf085;" ? 'selected':''}}>&#xf085; </option>
                                                                <option value="#xf0db;" {{ $metric->info_box_icon ===
                                                                    "#xf0db;" ? 'selected':''}}>&#xf0db; </option>
                                                                <option value="#xf075;" {{ $metric->info_box_icon ===
                                                                    "#xf075;" ? 'selected':''}}>&#xf075; </option>
                                                                <option value="#xf0e5;" {{ $metric->info_box_icon ===
                                                                    "#xf0e5;" ? 'selected':''}}>&#xf0e5; </option>
                                                                <option value="#xf27a;" {{ $metric->info_box_icon ===
                                                                    "#xf27a;" ? 'selected':''}}>&#xf27a; </option>
                                                                <option value="#xf27b;" {{ $metric->info_box_icon ===
                                                                    "#xf27b;" ? 'selected':''}}>&#xf27b; </option>
                                                                <option value="#xf086;" {{ $metric->info_box_icon ===
                                                                    "#xf086;" ? 'selected':''}}>&#xf086; </option>
                                                                <option value="#xf0e6;" {{ $metric->info_box_icon ===
                                                                    "#xf0e6;" ? 'selected':''}}>&#xf0e6; </option>
                                                                <option value="#xf14e;" {{ $metric->info_box_icon ===
                                                                    "#xf14e;" ? 'selected':''}}>&#xf14e; </option>
                                                                <option value="#xf066;" {{ $metric->info_box_icon ===
                                                                    "#xf066;" ? 'selected':''}}>&#xf066; </option>
                                                                <option value="#xf20e;" {{ $metric->info_box_icon ===
                                                                    "#xf20e;" ? 'selected':''}}>&#xf20e; </option>
                                                                <option value="#xf26d;" {{ $metric->info_box_icon ===
                                                                    "#xf26d;" ? 'selected':''}}>&#xf26d; </option>
                                                                <option value="#xf0c5;" {{ $metric->info_box_icon ===
                                                                    "#xf0c5;" ? 'selected':''}}>&#xf0c5; </option>
                                                                <option value="#xf1f9;" {{ $metric->info_box_icon ===
                                                                    "#xf1f9;" ? 'selected':''}}>&#xf1f9; </option>
                                                                <option value="#xf25e;" {{ $metric->info_box_icon ===
                                                                    "#xf25e;" ? 'selected':''}}>&#xf25e;</option>
                                                                <option value="#xf09d;" {{ $metric->info_box_icon ===
                                                                    "#xf09d;" ? 'selected':''}}>&#xf09d; </option>
                                                                <option value="#xf125;" {{ $metric->info_box_icon ===
                                                                    "#xf125;" ? 'selected':''}}>&#xf125; </option>
                                                                <option value="#xf05b;" {{ $metric->info_box_icon ===
                                                                    "#xf05b;" ? 'selected':''}}>&#xf05b; </option>
                                                                <option value="#xf13c;" {{ $metric->info_box_icon ===
                                                                    "#xf13c;" ? 'selected':''}}>&#xf13c; </option>
                                                                <option value="#xf1b2;" {{ $metric->info_box_icon ===
                                                                    "#xf1b2;" ? 'selected':''}}>&#xf1b2; </option>
                                                                <option value="#xf1b3;" {{ $metric->info_box_icon ===
                                                                    "#xf1b3;" ? 'selected':''}}>&#xf1b3; </option>
                                                                <option value="#xf0c4;" {{ $metric->info_box_icon ===
                                                                    "#xf0c4;" ? 'selected':''}}>&#xf0c4; </option>
                                                                <option value="#xf0f5;" {{ $metric->info_box_icon ===
                                                                    "#xf0f5;" ? 'selected':''}}>&#xf0f5; </option>
                                                                <option value="#xf0e4;" {{ $metric->info_box_icon ===
                                                                    "#xf0e4;" ? 'selected':''}}>&#xf0e4; </option>
                                                                <option value="#xf210;" {{ $metric->info_box_icon ===
                                                                    "#xf210;" ? 'selected':''}}>&#xf210; </option>
                                                                <option value="#xf1c0;" {{ $metric->info_box_icon ===
                                                                    "#xf1c0;" ? 'selected':''}}>&#xf1c0; </option>
                                                                <option value="#xf03b;" {{ $metric->info_box_icon ===
                                                                    "#xf03b;" ? 'selected':''}}>&#xf03b; </option>
                                                                <option value="#xf1a5;" {{ $metric->info_box_icon ===
                                                                    "#xf1a5;" ? 'selected':''}}>&#xf1a5; </option>
                                                                <option value="#xf108;" {{ $metric->info_box_icon ===
                                                                    "#xf108;" ? 'selected':''}}>&#xf108; </option>
                                                                <option value="#xf1bd;" {{ $metric->info_box_icon ===
                                                                    "#xf1bd;" ? 'selected':''}}>&#xf1bd; </option>
                                                                <option value="#xf219;" {{ $metric->info_box_icon ===
                                                                    "#xf219;" ? 'selected':''}}>&#xf219; </option>
                                                                <option value="#xf1a6;" {{ $metric->info_box_icon ===
                                                                    "#xf1a6;" ? 'selected':''}}>&#xf1a6; </option>
                                                                <option value="#xf155;" {{ $metric->info_box_icon ===
                                                                    "#xf155;" ? 'selected':''}}>&#xf155; </option>
                                                                <option value="#xf019;" {{ $metric->info_box_icon ===
                                                                    "#xf019;" ? 'selected':''}}>&#xf019; </option>
                                                                <option value="#xf17d;" {{ $metric->info_box_icon ===
                                                                    "#xf17d;" ? 'selected':''}}>&#xf17d; </option>
                                                                <option value="#xf16b;" {{ $metric->info_box_icon ===
                                                                    "#xf16b;" ? 'selected':''}}>&#xf16b; </option>
                                                                <option value="#xf1a9;" {{ $metric->info_box_icon ===
                                                                    "#xf1a9;" ? 'selected':''}}>&#xf1a9; </option>
                                                                <option value="#xf044;" {{ $metric->info_box_icon ===
                                                                    "#xf044;" ? 'selected':''}}>&#xf044; </option>
                                                                <option value="#xf052;" {{ $metric->info_box_icon ===
                                                                    "#xf052;" ? 'selected':''}}>&#xf052; </option>
                                                                <option value="#xf141;" {{ $metric->info_box_icon ===
                                                                    "#xf141;" ? 'selected':''}}>&#xf141; </option>
                                                                <option value="#xf142;" {{ $metric->info_box_icon ===
                                                                    "#xf142;" ? 'selected':''}}>&#xf142; </option>
                                                                <option value="#xf1d1;" {{ $metric->info_box_icon ===
                                                                    "#xf1d1;" ? 'selected':''}}>&#xf1d1; </option>
                                                                <option value="#xf0e0;" {{ $metric->info_box_icon ===
                                                                    "#xf0e0;" ? 'selected':''}}>&#xf0e0; </option>
                                                                <option value="#xf003;" {{ $metric->info_box_icon ===
                                                                    "#xf003;" ? 'selected':''}}>&#xf003; </option>
                                                                <option value="#xf153;" {{ $metric->info_box_icon ===
                                                                    "#xf153;" ? 'selected':''}}>&#xf153; </option>
                                                                <option value="#xf153;" {{ $metric->info_box_icon ===
                                                                    "#xf153;" ? 'selected':''}}>&#xf153; </option>
                                                                <option value="#xf0ec;" {{ $metric->info_box_icon ===
                                                                    "#xf0ec;" ? 'selected':''}}>&#xf0ec; </option>
                                                                <option value="#xf12a;" {{ $metric->info_box_icon ===
                                                                    "#xf12a;" ? 'selected':''}}>&#xf12a; </option>
                                                                <option value="#xf06a;" {{ $metric->info_box_icon ===
                                                                    "#xf06a;" ? 'selected':''}}>&#xf06a;</option>
                                                                <option value="#xf071;" {{ $metric->info_box_icon ===
                                                                    "#xf071;" ? 'selected':''}}>&#xf071;</option>
                                                                <option value="#xf065;" {{ $metric->info_box_icon ===
                                                                    "#xf065;" ? 'selected':''}}>&#xf065; </option>
                                                                <option value="#xf23e;" {{ $metric->info_box_icon ===
                                                                    "#xf23e;" ? 'selected':''}}>&#xf23e; </option>
                                                                <option value="#xf08e;" {{ $metric->info_box_icon ===
                                                                    "#xf08e;" ? 'selected':''}}>&#xf08e; </option>
                                                                <option value="#xf14c;" {{ $metric->info_box_icon ===
                                                                    "#xf14c;" ? 'selected':''}}>&#xf14c;</option>
                                                                <option value="#xf06e;" {{ $metric->info_box_icon ===
                                                                    "#xf06e;" ? 'selected':''}}>&#xf06e; </option>
                                                                <option value="#xf070;" {{ $metric->info_box_icon ===
                                                                    "#xf070;" ? 'selected':''}}>&#xf070; </option>
                                                                <option value="#xf1fb;" {{ $metric->info_box_icon ===
                                                                    "#xf1fb;" ? 'selected':''}}>&#xf1fb; </option>
                                                                <option value="#xf09a;" {{ $metric->info_box_icon ===
                                                                    "#xf09a;" ? 'selected':''}}>&#xf09a; </option>
                                                                <option value="#xf09a;" {{ $metric->info_box_icon ===
                                                                    "#xf09a;" ? 'selected':''}}>&#xf09a; </option>
                                                                <option value="#xf230;" {{ $metric->info_box_icon ===
                                                                    "#xf230;" ? 'selected':''}}>&#xf230;</option>
                                                                <option value="#xf082;" {{ $metric->info_box_icon ===
                                                                    "#xf082;" ? 'selected':''}}>&#xf082;</option>
                                                                <option value="#xf049;" {{ $metric->info_box_icon ===
                                                                    "#xf049;" ? 'selected':''}}>&#xf049; </option>
                                                                <option value="#xf050;" {{ $metric->info_box_icon ===
                                                                    "#xf050;" ? 'selected':''}}>&#xf050; </option>
                                                                <option value="#xf1ac;" {{ $metric->info_box_icon ===
                                                                    "#xf1ac;" ? 'selected':''}}>&#xf1ac; </option>
                                                                <option value="#xf09e;" {{ $metric->info_box_icon ===
                                                                    "#xf09e;" ? 'selected':''}}>&#xf09e; </option>
                                                                <option value="#xf182;" {{ $metric->info_box_icon ===
                                                                    "#xf182;" ? 'selected':''}}>&#xf182; </option>
                                                                <option value="#xf0fb;" {{ $metric->info_box_icon ===
                                                                    "#xf0fb;" ? 'selected':''}}>&#xf0fb; </option>
                                                                <option value="#xf15b;" {{ $metric->info_box_icon ===
                                                                    "#xf15b;" ? 'selected':''}}>&#xf15b; </option>
                                                                <option value="#xf1c6;" {{ $metric->info_box_icon ===
                                                                    "#xf1c6;" ? 'selected':''}}>&#xf1c6; </option>
                                                                <option value="#xf1c7;" {{ $metric->info_box_icon ===
                                                                    "#xf1c7;" ? 'selected':''}}>&#xf1c7; </option>
                                                                <option value="#xf1c9;" {{ $metric->info_box_icon ===
                                                                    "#xf1c9;" ? 'selected':''}}>&#xf1c9; </option>
                                                                <option value="#xf1c3;" {{ $metric->info_box_icon ===
                                                                    "#xf1c3;" ? 'selected':''}}>&#xf1c3; </option>
                                                                <option value="#xf1c5;" {{ $metric->info_box_icon ===
                                                                    "#xf1c5;" ? 'selected':''}}>&#xf1c5; </option>
                                                                <option value="#xf1c8;" {{ $metric->info_box_icon ===
                                                                    "#xf1c8;" ? 'selected':''}}>&#xf1c8; </option>
                                                                <option value="#xf016;" {{ $metric->info_box_icon ===
                                                                    "#xf016;" ? 'selected':''}}>&#xf016; </option>
                                                                <option value="#xf1c1;" {{ $metric->info_box_icon ===
                                                                    "#xf1c1;" ? 'selected':''}}>&#xf1c1; </option>
                                                                <option value="#xf1c5;" {{ $metric->info_box_icon ===
                                                                    "#xf1c5;" ? 'selected':''}}>&#xf1c5; </option>
                                                                <option value="#xf1c5;" {{ $metric->info_box_icon ===
                                                                    "#xf1c5;" ? 'selected':''}}>&#xf1c5; </option>
                                                                <option value="#xf1c4;" {{ $metric->info_box_icon ===
                                                                    "#xf1c4;" ? 'selected':''}}>&#xf1c4;</option>
                                                                <option value="#xf1c7;" {{ $metric->info_box_icon ===
                                                                    "#xf1c7;" ? 'selected':''}}>&#xf1c7; </option>
                                                                <option value="#xf15c;" {{ $metric->info_box_icon ===
                                                                    "#xf15c;" ? 'selected':''}}>&#xf15c; </option>
                                                                <option value="#xf0f6;" {{ $metric->info_box_icon ===
                                                                    "#xf0f6;" ? 'selected':''}}>&#xf0f6; </option>
                                                                <option value="#xf1c8;" {{ $metric->info_box_icon ===
                                                                    "#xf1c8;" ? 'selected':''}}>&#xf1c8; </option>
                                                                <option value="#xf1c2;" {{ $metric->info_box_icon ===
                                                                    "#xf1c2;" ? 'selected':''}}>&#xf1c2; </option>
                                                                <option value="#xf1c6;" {{ $metric->info_box_icon ===
                                                                    "#xf1c6;" ? 'selected':''}}>&#xf1c6; </option>
                                                                <option value="#xf0c5;" {{ $metric->info_box_icon ===
                                                                    "#xf0c5;" ? 'selected':''}}>&#xf0c5; </option>
                                                                <option value="#xf008;" {{ $metric->info_box_icon ===
                                                                    "#xf008;" ? 'selected':''}}>&#xf008; </option>
                                                                <option value="#xf0b0;" {{ $metric->info_box_icon ===
                                                                    "#xf0b0;" ? 'selected':''}}>&#xf0b0; </option>
                                                                <option value="#xf06d;" {{ $metric->info_box_icon ===
                                                                    "#xf06d;" ? 'selected':''}}>&#xf06d; </option>
                                                                <option value="#xf134;" {{ $metric->info_box_icon ===
                                                                    "#xf134;" ? 'selected':''}}>&#xf134;</option>
                                                                <option value="#xf269;" {{ $metric->info_box_icon ===
                                                                    "#xf269;" ? 'selected':''}}>&#xf269; </option>
                                                                <option value="#xf024;" {{ $metric->info_box_icon ===
                                                                    "#xf024;" ? 'selected':''}}>&#xf024; </option>
                                                                <option value="#xf11e;" {{ $metric->info_box_icon ===
                                                                    "#xf11e;" ? 'selected':''}}>&#xf11e; </option>
                                                                <option value="#xf11d;" {{ $metric->info_box_icon ===
                                                                    "#xf11d;" ? 'selected':''}}>&#xf11d; </option>
                                                                <option value="#xf0e7;" {{ $metric->info_box_icon ===
                                                                    "#xf0e7;" ? 'selected':''}}>&#xf0e7; </option>
                                                                <option value="#xf0c3;" {{ $metric->info_box_icon ===
                                                                    "#xf0c3;" ? 'selected':''}}>&#xf0c3; </option>
                                                                <option value="#xf16e;" {{ $metric->info_box_icon ===
                                                                    "#xf16e;" ? 'selected':''}}>&#xf16e; </option>
                                                                <option value="#xf0c7;" {{ $metric->info_box_icon ===
                                                                    "#xf0c7;" ? 'selected':''}}>&#xf0c7; </option>
                                                                <option value="#xf07b;" {{ $metric->info_box_icon ===
                                                                    "#xf07b;" ? 'selected':''}}>&#xf07b; </option>
                                                                <option value="#xf114;" {{ $metric->info_box_icon ===
                                                                    "#xf114;" ? 'selected':''}}>&#xf114; </option>
                                                                <option value="#xf07c;" {{ $metric->info_box_icon ===
                                                                    "#xf07c;" ? 'selected':''}}>&#xf07c; </option>
                                                                <option value="#xf115;" {{ $metric->info_box_icon ===
                                                                    "#xf115;" ? 'selected':''}}>&#xf115; </option>
                                                                <option value="#xf031;" {{ $metric->info_box_icon ===
                                                                    "#xf031;" ? 'selected':''}}>&#xf031; </option>
                                                                <option value="#xf280;" {{ $metric->info_box_icon ===
                                                                    "#xf280;" ? 'selected':''}}>&#xf280; </option>
                                                                <option value="#xf211;" {{ $metric->info_box_icon ===
                                                                    "#xf211;" ? 'selected':''}}>&#xf211; </option>
                                                                <option value="#xf04e;" {{ $metric->info_box_icon ===
                                                                    "#xf04e;" ? 'selected':''}}>&#xf04e; </option>
                                                                <option value="#xf180;" {{ $metric->info_box_icon ===
                                                                    "#xf180;" ? 'selected':''}}>&#xf180; </option>
                                                                <option value="#xf119;" {{ $metric->info_box_icon ===
                                                                    "#xf119;" ? 'selected':''}}>&#xf119; </option>
                                                                <option value="#xf1e3;" {{ $metric->info_box_icon ===
                                                                    "#xf1e3;" ? 'selected':''}}>&#xf1e3; </option>
                                                                <option value="#xf11b;" {{ $metric->info_box_icon ===
                                                                    "#xf11b;" ? 'selected':''}}>&#xf11b; </option>
                                                                <option value="#xf0e3;" {{ $metric->info_box_icon ===
                                                                    "#xf0e3;" ? 'selected':''}}>&#xf0e3; </option>
                                                                <option value="#xf154;" {{ $metric->info_box_icon ===
                                                                    "#xf154;" ? 'selected':''}}>&#xf154; </option>
                                                                <option value="#xf1d1;" {{ $metric->info_box_icon ===
                                                                    "#xf1d1;" ? 'selected':''}}>&#xf1d1; </option>
                                                                <option value="#xf013;" {{ $metric->info_box_icon ===
                                                                    "#xf013;" ? 'selected':''}}>&#xf013; </option>
                                                                <option value="#xf085;" {{ $metric->info_box_icon ===
                                                                    "#xf085;" ? 'selected':''}}>&#xf085; </option>
                                                                <option value="#xf22d;" {{ $metric->info_box_icon ===
                                                                    "#xf22d;" ? 'selected':''}}>&#xf22d; </option>
                                                                <option value="#xf265;" {{ $metric->info_box_icon ===
                                                                    "#xf265;" ? 'selected':''}}>&#xf265; </option>
                                                                <option value="#xf260;" {{ $metric->info_box_icon ===
                                                                    "#xf260;" ? 'selected':''}}>&#xf260; </option>
                                                                <option value="#xf261;" {{ $metric->info_box_icon ===
                                                                    "#xf261;" ? 'selected':''}}>&#xf261; </option>
                                                                <option value="#xf06b;" {{ $metric->info_box_icon ===
                                                                    "#xf06b;" ? 'selected':''}}>&#xf06b; </option>
                                                                <option value="#xf1d3;" {{ $metric->info_box_icon ===
                                                                    "#xf1d3;" ? 'selected':''}}>&#xf1d3; </option>
                                                                <option value="#xf1d2;" {{ $metric->info_box_icon ===
                                                                    "#xf1d2;" ? 'selected':''}}>&#xf1d2; </option>
                                                                <option value="#xf09b;" {{ $metric->info_box_icon ===
                                                                    "#xf09b;" ? 'selected':''}}>&#xf09b; </option>
                                                                <option value="#xf113;" {{ $metric->info_box_icon ===
                                                                    "#xf113;" ? 'selected':''}}>&#xf113; </option>
                                                                <option value="#xf092;" {{ $metric->info_box_icon ===
                                                                    "#xf092;" ? 'selected':''}}>&#xf092; </option>
                                                                <option value="#xf184;" {{ $metric->info_box_icon ===
                                                                    "#xf184;" ? 'selected':''}}>&#xf184; </option>
                                                                <option value="#xf000;" {{ $metric->info_box_icon ===
                                                                    "#xf000;" ? 'selected':''}}>&#xf000; </option>
                                                                <option value="#xf0ac;" {{ $metric->info_box_icon ===
                                                                    "#xf0ac;" ? 'selected':''}}>&#xf0ac; </option>
                                                                <option value="#xf1a0;" {{ $metric->info_box_icon ===
                                                                    "#xf1a0;" ? 'selected':''}}>&#xf1a0; </option>
                                                                <option value="#xf0d5;" {{ $metric->info_box_icon ===
                                                                    "#xf0d5;" ? 'selected':''}}>&#xf0d5; </option>
                                                                <option value="#xf0d4;" {{ $metric->info_box_icon ===
                                                                    "#xf0d4;" ? 'selected':''}}>&#xf0d4;</option>
                                                                <option value="#xf1ee;" {{ $metric->info_box_icon ===
                                                                    "#xf1ee;" ? 'selected':''}}>&#xf1ee; </option>
                                                                <option value="#xf19d;" {{ $metric->info_box_icon ===
                                                                    "#xf19d;" ? 'selected':''}}>&#xf19d; </option>
                                                                <option value="#xf184;" {{ $metric->info_box_icon ===
                                                                    "#xf184;" ? 'selected':''}}>&#xf184; </option>
                                                                <option value="#xf0c0;" {{ $metric->info_box_icon ===
                                                                    "#xf0c0;" ? 'selected':''}}>&#xf0c0; </option>
                                                                <option value="#xf0fd;" {{ $metric->info_box_icon ===
                                                                    "#xf0fd;" ? 'selected':''}}>&#xf0fd; </option>
                                                                <option value="#xf1d4;" {{ $metric->info_box_icon ===
                                                                    "#xf1d4;" ? 'selected':''}}>&#xf1d4; </option>
                                                                <option value="#xf255;" {{ $metric->info_box_icon ===
                                                                    "#xf255;" ? 'selected':''}}>&#xf255; </option>
                                                                <option value="#xf258;" {{ $metric->info_box_icon ===
                                                                    "#xf258;" ? 'selected':''}}>&#xf258; </option>
                                                                <option value="#xf0a7;" {{ $metric->info_box_icon ===
                                                                    "#xf0a7;" ? 'selected':''}}>&#xf0a7; </option>
                                                                <option value="#xf0a5;" {{ $metric->info_box_icon ===
                                                                    "#xf0a5;" ? 'selected':''}}>&#xf0a5; </option>
                                                                <option value="#xf0a4;" {{ $metric->info_box_icon ===
                                                                    "#xf0a4;" ? 'selected':''}}>&#xf0a4; </option>
                                                                <option value="#xf0a6;" {{ $metric->info_box_icon ===
                                                                    "#xf0a6;" ? 'selected':''}}>&#xf0a6; </option>
                                                                <option value="#xf256;" {{ $metric->info_box_icon ===
                                                                    "#xf256;" ? 'selected':''}}>&#xf256; </option>
                                                                <option value="#xf25b;" {{ $metric->info_box_icon ===
                                                                    "#xf25b;" ? 'selected':''}}>&#xf25b; </option>
                                                                <option value="#xf25a;" {{ $metric->info_box_icon ===
                                                                    "#xf25a;" ? 'selected':''}}>&#xf25a; </option>
                                                                <option value="#xf255;" {{ $metric->info_box_icon ===
                                                                    "#xf255;" ? 'selected':''}}>&#xf255; </option>
                                                                <option value="#xf257;" {{ $metric->info_box_icon ===
                                                                    "#xf257;" ? 'selected':''}}>&#xf257;</option>
                                                                <option value="#xf259;" {{ $metric->info_box_icon ===
                                                                    "#xf259;" ? 'selected':''}}>&#xf259; </option>
                                                                <option value="#xf256;" {{ $metric->info_box_icon ===
                                                                    "#xf256;" ? 'selected':''}}>&#xf256; </option>
                                                                <option value="#xf0a0;" {{ $metric->info_box_icon ===
                                                                    "#xf0a0;" ? 'selected':''}}>&#xf0a0; </option>
                                                                <option value="#xf1dc;" {{ $metric->info_box_icon ===
                                                                    "#xf1dc;" ? 'selected':''}}>&#xf1dc; </option>
                                                                <option value="#xf025;" {{ $metric->info_box_icon ===
                                                                    "#xf025;" ? 'selected':''}}>&#xf025; </option>
                                                                <option value="#xf004;" {{ $metric->info_box_icon ===
                                                                    "#xf004;" ? 'selected':''}}>&#xf004; </option>
                                                                <option value="#xf08a;" {{ $metric->info_box_icon ===
                                                                    "#xf08a;" ? 'selected':''}}>&#xf08a; </option>
                                                                <option value="#xf21e;" {{ $metric->info_box_icon ===
                                                                    "#xf21e;" ? 'selected':''}}>&#xf21e; </option>
                                                                <option value="#xf1da;" {{ $metric->info_box_icon ===
                                                                    "#xf1da;" ? 'selected':''}}>&#xf1da; </option>
                                                                <option value="#xf015;" {{ $metric->info_box_icon ===
                                                                    "#xf015;" ? 'selected':''}}>&#xf015; </option>
                                                                <option value="#xf0f8;" {{ $metric->info_box_icon ===
                                                                    "#xf0f8;" ? 'selected':''}}>&#xf0f8; </option>
                                                                <option value="#xf236;" {{ $metric->info_box_icon ===
                                                                    "#xf236;" ? 'selected':''}}>&#xf236; </option>
                                                                <option value="#xf254;" {{ $metric->info_box_icon ===
                                                                    "#xf254;" ? 'selected':''}}>&#xf254; </option>
                                                                <option value="#xf251;" {{ $metric->info_box_icon ===
                                                                    "#xf251;" ? 'selected':''}}>&#xf251; </option>
                                                                <option value="#xf252;" {{ $metric->info_box_icon ===
                                                                    "#xf252;" ? 'selected':''}}>&#xf252; </option>
                                                                <option value="#xf253;" {{ $metric->info_box_icon ===
                                                                    "#xf253;" ? 'selected':''}}>&#xf253; </option>
                                                                <option value="#xf253;" {{ $metric->info_box_icon ===
                                                                    "#xf253;" ? 'selected':''}}>&#xf253; </option>
                                                                <option value="#xf252;" {{ $metric->info_box_icon ===
                                                                    "#xf252;" ? 'selected':''}}>&#xf252; </option>
                                                                <option value="#xf250;" {{ $metric->info_box_icon ===
                                                                    "#xf250;" ? 'selected':''}}>&#xf250; </option>
                                                                <option value="#xf251;" {{ $metric->info_box_icon ===
                                                                    "#xf251;" ? 'selected':''}}>&#xf251;</option>
                                                                <option value="#xf27c;" {{ $metric->info_box_icon ===
                                                                    "#xf27c;" ? 'selected':''}}>&#xf27c; </option>
                                                                <option value="#xf13b;" {{ $metric->info_box_icon ===
                                                                    "#xf13b;" ? 'selected':''}}>&#xf13b; </option>
                                                                <option value="#xf246;" {{ $metric->info_box_icon ===
                                                                    "#xf246;" ? 'selected':''}}>&#xf246; </option>
                                                                <option value="#xf20b;" {{ $metric->info_box_icon ===
                                                                    "#xf20b;" ? 'selected':''}}>&#xf20b; </option>
                                                                <option value="#xf03e;" {{ $metric->info_box_icon ===
                                                                    "#xf03e;" ? 'selected':''}}>&#xf03e; </option>
                                                                <option value="#xf01c;" {{ $metric->info_box_icon ===
                                                                    "#xf01c;" ? 'selected':''}}>&#xf01c; </option>
                                                                <option value="#xf03c;" {{ $metric->info_box_icon ===
                                                                    "#xf03c;" ? 'selected':''}}>&#xf03c; </option>
                                                                <option value="#xf275;" {{ $metric->info_box_icon ===
                                                                    "#xf275;" ? 'selected':''}}>&#xf275; </option>
                                                                <option value="#xf129;" {{ $metric->info_box_icon ===
                                                                    "#xf129;" ? 'selected':''}}>&#xf129; </option>
                                                                <option value="#xf05a;" {{ $metric->info_box_icon ===
                                                                    "#xf05a;" ? 'selected':''}}>&#xf05a; </option>
                                                                <option value="#xf156;" {{ $metric->info_box_icon ===
                                                                    "#xf156;" ? 'selected':''}}>&#xf156; </option>
                                                                <option value="#xf16d;" {{ $metric->info_box_icon ===
                                                                    "#xf16d;" ? 'selected':''}}>&#xf16d; </option>
                                                                <option value="#xf19c;" {{ $metric->info_box_icon ===
                                                                    "#xf19c;" ? 'selected':''}}>&#xf19c; </option>
                                                                <option value="#xf26b;" {{ $metric->info_box_icon ===
                                                                    "#xf26b;" ? 'selected':''}}>&#xf26b;</option>
                                                                <option value="#xf224;" {{ $metric->info_box_icon ===
                                                                    "#xf224;" ? 'selected':''}}>&#xf224; </option>
                                                                <option value="#xf208;" {{ $metric->info_box_icon ===
                                                                    "#xf208;" ? 'selected':''}}>&#xf208; </option>
                                                                <option value="#xf033;" {{ $metric->info_box_icon ===
                                                                    "#xf033;" ? 'selected':''}}>&#xf033; </option>
                                                                <option value="#xf1aa;" {{ $metric->info_box_icon ===
                                                                    "#xf1aa;" ? 'selected':''}}>&#xf1aa; </option>
                                                                <option value="#xf157;" {{ $metric->info_box_icon ===
                                                                    "#xf157;" ? 'selected':''}}>&#xf157; </option>
                                                                <option value="#xf1cc;" {{ $metric->info_box_icon ===
                                                                    "#xf1cc;" ? 'selected':''}}>&#xf1cc; </option>
                                                                <option value="#xf084;" {{ $metric->info_box_icon ===
                                                                    "#xf084;" ? 'selected':''}}>&#xf084; </option>
                                                                <option value="#xf11c;" {{ $metric->info_box_icon ===
                                                                    "#xf11c;" ? 'selected':''}}>&#xf11c; </option>
                                                                <option value="#xf159;" {{ $metric->info_box_icon ===
                                                                    "#xf159;" ? 'selected':''}}>&#xf159; </option>
                                                                <option value="#xf1ab;" {{ $metric->info_box_icon ===
                                                                    "#xf1ab;" ? 'selected':''}}>&#xf1ab; </option>
                                                                <option value="#xf109;" {{ $metric->info_box_icon ===
                                                                    "#xf109;" ? 'selected':''}}>&#xf109; </option>
                                                                <option value="#xf202;" {{ $metric->info_box_icon ===
                                                                    "#xf202;" ? 'selected':''}}>&#xf202; </option>
                                                                <option value="#xf203;" {{ $metric->info_box_icon ===
                                                                    "#xf203;" ? 'selected':''}}>&#xf203; </option>
                                                                <option value="#xf06c;" {{ $metric->info_box_icon ===
                                                                    "#xf06c;" ? 'selected':''}}>&#xf06c; </option>
                                                                <option value="#xf212;" {{ $metric->info_box_icon ===
                                                                    "#xf212;" ? 'selected':''}}>&#xf212; </option>
                                                                <option value="#xf0e3;" {{ $metric->info_box_icon ===
                                                                    "#xf0e3;" ? 'selected':''}}>&#xf0e3; </option>
                                                                <option value="#xf094;" {{ $metric->info_box_icon ===
                                                                    "#xf094;" ? 'selected':''}}>&#xf094; </option>
                                                                <option value="#xf149;" {{ $metric->info_box_icon ===
                                                                    "#xf149;" ? 'selected':''}}>&#xf149; </option>
                                                                <option value="#xf148;" {{ $metric->info_box_icon ===
                                                                    "#xf148;" ? 'selected':''}}>&#xf148; </option>
                                                                <option value="#xf1cd;" {{ $metric->info_box_icon ===
                                                                    "#xf1cd;" ? 'selected':''}}>&#xf1cd; </option>
                                                                <option value="#xf1cd;" {{ $metric->info_box_icon ===
                                                                    "#xf1cd;" ? 'selected':''}}>&#xf1cd; </option>
                                                                <option value="#xf1cd;" {{ $metric->info_box_icon ===
                                                                    "#xf1cd;" ? 'selected':''}}>&#xf1cd; </option>
                                                                <option value="#xf1cd;" {{ $metric->info_box_icon ===
                                                                    "#xf1cd;" ? 'selected':''}}>&#xf1cd; </option>
                                                                <option value="#xf0eb;" {{ $metric->info_box_icon ===
                                                                    "#xf0eb;" ? 'selected':''}}>&#xf0eb; </option>
                                                                <option value="#xf201;" {{ $metric->info_box_icon ===
                                                                    "#xf201;" ? 'selected':''}}>&#xf201; </option>
                                                                <option value="#xf0c1;" {{ $metric->info_box_icon ===
                                                                    "#xf0c1;" ? 'selected':''}}>&#xf0c1; </option>
                                                                <option value="#xf0e1;" {{ $metric->info_box_icon ===
                                                                    "#xf0e1;" ? 'selected':''}}>&#xf0e1; </option>
                                                                <option value="#xf08c;" {{ $metric->info_box_icon ===
                                                                    "#xf08c;" ? 'selected':''}}>&#xf08c;</option>
                                                                <option value="#xf17c;" {{ $metric->info_box_icon ===
                                                                    "#xf17c;" ? 'selected':''}}>&#xf17c; </option>
                                                                <option value="#xf03a;" {{ $metric->info_box_icon ===
                                                                    "#xf03a;" ? 'selected':''}}>&#xf03a; </option>
                                                                <option value="#xf022;" {{ $metric->info_box_icon ===
                                                                    "#xf022;" ? 'selected':''}}>&#xf022; </option>
                                                                <option value="#xf0cb;" {{ $metric->info_box_icon ===
                                                                    "#xf0cb;" ? 'selected':''}}>&#xf0cb; </option>
                                                                <option value="#xf0ca;" {{ $metric->info_box_icon ===
                                                                    "#xf0ca;" ? 'selected':''}}>&#xf0ca; </option>
                                                                <option value="#xf124;" {{ $metric->info_box_icon ===
                                                                    "#xf124;" ? 'selected':''}}>&#xf124; </option>
                                                                <option value="#xf023;" {{ $metric->info_box_icon ===
                                                                    "#xf023;" ? 'selected':''}}>&#xf023; </option>
                                                                <option value="#xf175;" {{ $metric->info_box_icon ===
                                                                    "#xf175;" ? 'selected':''}}>&#xf175;</option>
                                                                <option value="#xf177;" {{ $metric->info_box_icon ===
                                                                    "#xf177;" ? 'selected':''}}>&#xf177;</option>
                                                                <option value="#xf178;" {{ $metric->info_box_icon ===
                                                                    "#xf178;" ? 'selected':''}}>&#xf178;</option>
                                                                <option value="#xf176;" {{ $metric->info_box_icon ===
                                                                    "#xf176;" ? 'selected':''}}>&#xf176; </option>
                                                                <option value="#xf0d0;" {{ $metric->info_box_icon ===
                                                                    "#xf0d0;" ? 'selected':''}}>&#xf0d0; </option>
                                                                <option value="#xf076;" {{ $metric->info_box_icon ===
                                                                    "#xf076;" ? 'selected':''}}>&#xf076; </option>
                                                                <option value="#xf22a;" {{ $metric->info_box_icon ===
                                                                    "#xf22a;" ? 'selected':''}}>&#xf22a; </option>
                                                                <option value="#xf136;" {{ $metric->info_box_icon ===
                                                                    "#xf136;" ? 'selected':''}}>&#xf136; </option>
                                                                <option value="#xf20c;" {{ $metric->info_box_icon ===
                                                                    "#xf20c;" ? 'selected':''}}>&#xf20c; </option>
                                                                <option value="#xf23a;" {{ $metric->info_box_icon ===
                                                                    "#xf23a;" ? 'selected':''}}>&#xf23a; </option>
                                                                <option value="#xf0fa;" {{ $metric->info_box_icon ===
                                                                    "#xf0fa;" ? 'selected':''}}>&#xf0fa; </option>
                                                                <option value="#xf11a;" {{ $metric->info_box_icon ===
                                                                    "#xf11a;" ? 'selected':''}}>&#xf11a; </option>
                                                                <option value="#xf223;" {{ $metric->info_box_icon ===
                                                                    "#xf223;" ? 'selected':''}}>&#xf223; </option>
                                                                <option value="#xf130;" {{ $metric->info_box_icon ===
                                                                    "#xf130;" ? 'selected':''}}>&#xf130; </option>
                                                                <option value="#xf10b;" {{ $metric->info_box_icon ===
                                                                    "#xf10b;" ? 'selected':''}}>&#xf10b; </option>
                                                                <option value="#xf21c;" {{ $metric->info_box_icon ===
                                                                    "#xf21c;" ? 'selected':''}}>&#xf21c; </option>
                                                                <option value="#xf245;" {{ $metric->info_box_icon ===
                                                                    "#xf245;" ? 'selected':''}}>&#xf245; </option>
                                                                <option value="#xf001;" {{ $metric->info_box_icon ===
                                                                    "#xf001;" ? 'selected':''}}>&#xf001; </option>
                                                                <option value="#xf0c9;" {{ $metric->info_box_icon ===
                                                                    "#xf0c9;" ? 'selected':''}}>&#xf0c9; </option>
                                                                <option value="#xf22c;" {{ $metric->info_box_icon ===
                                                                    "#xf22c;" ? 'selected':''}}>&#xf22c; </option>
                                                                <option value="#xf1ea;" {{ $metric->info_box_icon ===
                                                                    "#xf1ea;" ? 'selected':''}}>&#xf1ea; </option>
                                                                <option value="#xf23d;" {{ $metric->info_box_icon ===
                                                                    "#xf23d;" ? 'selected':''}}>&#xf23d; </option>
                                                                <option value="#xf19b;" {{ $metric->info_box_icon ===
                                                                    "#xf19b;" ? 'selected':''}}>&#xf19b; </option>
                                                                <option value="#xf26a;" {{ $metric->info_box_icon ===
                                                                    "#xf26a;" ? 'selected':''}}>&#xf26a; </option>
                                                                <option value="#xf03b;" {{ $metric->info_box_icon ===
                                                                    "#xf03b;" ? 'selected':''}}>&#xf03b; </option>
                                                                <option value="#xf18c;" {{ $metric->info_box_icon ===
                                                                    "#xf18c;" ? 'selected':''}}>&#xf18c; </option>
                                                                <option value="#xf1d9;" {{ $metric->info_box_icon ===
                                                                    "#xf1d9;" ? 'selected':''}}>&#xf1d9; </option>
                                                                <option value="#xf0c6;" {{ $metric->info_box_icon ===
                                                                    "#xf0c6;" ? 'selected':''}}>&#xf0c6; </option>
                                                                <option value="#xf1dd;" {{ $metric->info_box_icon ===
                                                                    "#xf1dd;" ? 'selected':''}}>&#xf1dd; </option>
                                                                <option value="#xf0ea;" {{ $metric->info_box_icon ===
                                                                    "#xf0ea;" ? 'selected':''}}>&#xf0ea; </option>
                                                                <option value="#xf04c;" {{ $metric->info_box_icon ===
                                                                    "#xf04c;" ? 'selected':''}}>&#xf04c; </option>
                                                                <option value="#xf1b0;" {{ $metric->info_box_icon ===
                                                                    "#xf1b0;" ? 'selected':''}}>&#xf1b0; </option>
                                                                <option value="#xf1ed;" {{ $metric->info_box_icon ===
                                                                    "#xf1ed;" ? 'selected':''}}>&#xf1ed; </option>
                                                                <option value="#xf040;" {{ $metric->info_box_icon ===
                                                                    "#xf040;" ? 'selected':''}}>&#xf040; </option>
                                                                <option value="#xf044;" {{ $metric->info_box_icon ===
                                                                    "#xf044;" ? 'selected':''}}>&#xf044;</option>
                                                                <option value="#xf095;" {{ $metric->info_box_icon ===
                                                                    "#xf095;" ? 'selected':''}}>&#xf095; </option>
                                                                <option value="#xf03e;" {{ $metric->info_box_icon ===
                                                                    "#xf03e;" ? 'selected':''}}>&#xf03e; </option>
                                                                <option value="#xf03e;" {{ $metric->info_box_icon ===
                                                                    "#xf03e;" ? 'selected':''}}>&#xf03e; </option>
                                                                <option value="#xf200;" {{ $metric->info_box_icon ===
                                                                    "#xf200;" ? 'selected':''}}>&#xf200; </option>
                                                                <option value="#xf1a7;" {{ $metric->info_box_icon ===
                                                                    "#xf1a7;" ? 'selected':''}}>&#xf1a7; </option>
                                                                <option value="#xf1a8;" {{ $metric->info_box_icon ===
                                                                    "#xf1a8;" ? 'selected':''}}>&#xf1a8; </option>
                                                                <option value="#xf0d2;" {{ $metric->info_box_icon ===
                                                                    "#xf0d2;" ? 'selected':''}}>&#xf0d2; </option>
                                                                <option value="#xf231;" {{ $metric->info_box_icon ===
                                                                    "#xf231;" ? 'selected':''}}>&#xf231; </option>
                                                                <option value="#xf0d3;" {{ $metric->info_box_icon ===
                                                                    "#xf0d3;" ? 'selected':''}}>&#xf0d3;</option>
                                                                <option value="#xf072;" {{ $metric->info_box_icon ===
                                                                    "#xf072;" ? 'selected':''}}>&#xf072; </option>
                                                                <option value="#xf04b;" {{ $metric->info_box_icon ===
                                                                    "#xf04b;" ? 'selected':''}}>&#xf04b; </option>
                                                                <option value="#xf144;" {{ $metric->info_box_icon ===
                                                                    "#xf144;" ? 'selected':''}}>&#xf144; </option>
                                                                <option value="#xf01d;" {{ $metric->info_box_icon ===
                                                                    "#xf01d;" ? 'selected':''}}>&#xf01d; </option>
                                                                <option value="#xf1e6;" {{ $metric->info_box_icon ===
                                                                    "#xf1e6;" ? 'selected':''}}>&#xf1e6; </option>
                                                                <option value="#xf067;" {{ $metric->info_box_icon ===
                                                                    "#xf067;" ? 'selected':''}}>&#xf067; </option>
                                                                <option value="#xf055;" {{ $metric->info_box_icon ===
                                                                    "#xf055;" ? 'selected':''}}>&#xf055; </option>
                                                                <option value="#xf0fe;" {{ $metric->info_box_icon ===
                                                                    "#xf0fe;" ? 'selected':''}}>&#xf0fe; </option>
                                                                <option value="#xf196;" {{ $metric->info_box_icon ===
                                                                    "#xf196;" ? 'selected':''}}>&#xf196; </option>
                                                                <option value="#xf011;" {{ $metric->info_box_icon ===
                                                                    "#xf011;" ? 'selected':''}}>&#xf011; </option>
                                                                <option value="#xf02f;" {{ $metric->info_box_icon ===
                                                                    "#xf02f;" ? 'selected':''}}>&#xf02f; </option>
                                                                <option value="#xf12e;" {{ $metric->info_box_icon ===
                                                                    "#xf12e;" ? 'selected':''}}>&#xf12e; </option>
                                                                <option value="#xf1d6;" {{ $metric->info_box_icon ===
                                                                    "#xf1d6;" ? 'selected':''}}>&#xf1d6; </option>
                                                                <option value="#xf029;" {{ $metric->info_box_icon ===
                                                                    "#xf029;" ? 'selected':''}}>&#xf029; </option>
                                                                <option value="#xf128;" {{ $metric->info_box_icon ===
                                                                    "#xf128;" ? 'selected':''}}>&#xf128; </option>
                                                                <option value="#xf059;" {{ $metric->info_box_icon ===
                                                                    "#xf059;" ? 'selected':''}}>&#xf059;</option>
                                                                <option value="#xf10d;" {{ $metric->info_box_icon ===
                                                                    "#xf10d;" ? 'selected':''}}>&#xf10d; </option>
                                                                <option value="#xf10e;" {{ $metric->info_box_icon ===
                                                                    "#xf10e;" ? 'selected':''}}>&#xf10e; </option>
                                                                <option value="#xf1d0;" {{ $metric->info_box_icon ===
                                                                    "#xf1d0;" ? 'selected':''}}>&#xf1d0; </option>
                                                                <option value="#xf074;" {{ $metric->info_box_icon ===
                                                                    "#xf074;" ? 'selected':''}}>&#xf074; </option>
                                                                <option value="#xf1d0;" {{ $metric->info_box_icon ===
                                                                    "#xf1d0;" ? 'selected':''}}>&#xf1d0; </option>
                                                                <option value="#xf1b8;" {{ $metric->info_box_icon ===
                                                                    "#xf1b8;" ? 'selected':''}}>&#xf1b8; </option>
                                                                <option value="#xf1a1;" {{ $metric->info_box_icon ===
                                                                    "#xf1a1;" ? 'selected':''}}>&#xf1a1; </option>
                                                                <option value="#xf1a2;" {{ $metric->info_box_icon ===
                                                                    "#xf1a2;" ? 'selected':''}}>&#xf1a2; </option>
                                                                <option value="#xf021;" {{ $metric->info_box_icon ===
                                                                    "#xf021;" ? 'selected':''}}>&#xf021; </option>
                                                                <option value="#xf25d;" {{ $metric->info_box_icon ===
                                                                    "#xf25d;" ? 'selected':''}}>&#xf25d; </option>
                                                                <option value="#xf00d;" {{ $metric->info_box_icon ===
                                                                    "#xf00d;" ? 'selected':''}}>&#xf00d; </option>
                                                                <option value="#xf18b;" {{ $metric->info_box_icon ===
                                                                    "#xf18b;" ? 'selected':''}}>&#xf18b; </option>
                                                                <option value="#xf0c9;" {{ $metric->info_box_icon ===
                                                                    "#xf0c9;" ? 'selected':''}}>&#xf0c9; </option>
                                                                <option value="#xf01e;" {{ $metric->info_box_icon ===
                                                                    "#xf01e;" ? 'selected':''}}>&#xf01e; </option>
                                                                <option value="#xf112;" {{ $metric->info_box_icon ===
                                                                    "#xf112;" ? 'selected':''}}>&#xf112; </option>
                                                                <option value="#xf122;" {{ $metric->info_box_icon ===
                                                                    "#xf122;" ? 'selected':''}}>&#xf122; </option>
                                                                <option value="#xf079;" {{ $metric->info_box_icon ===
                                                                    "#xf079;" ? 'selected':''}}>&#xf079; </option>
                                                                <option value="#xf157;" {{ $metric->info_box_icon ===
                                                                    "#xf157;" ? 'selected':''}}>&#xf157; </option>
                                                                <option value="#xf018;" {{ $metric->info_box_icon ===
                                                                    "#xf018;" ? 'selected':''}}>&#xf018; </option>
                                                                <option value="#xf135;" {{ $metric->info_box_icon ===
                                                                    "#xf135;" ? 'selected':''}}>&#xf135; </option>
                                                                <option value="#xf0e2;" {{ $metric->info_box_icon ===
                                                                    "#xf0e2;" ? 'selected':''}}>&#xf0e2; </option>
                                                                <option value="#xf01e;" {{ $metric->info_box_icon ===
                                                                    "#xf01e;" ? 'selected':''}}>&#xf01e; </option>
                                                                <option value="#xf158;" {{ $metric->info_box_icon ===
                                                                    "#xf158;" ? 'selected':''}}>&#xf158; </option>
                                                                <option value="#xf09e;" {{ $metric->info_box_icon ===
                                                                    "#xf09e;" ? 'selected':''}}>&#xf09e; </option>
                                                                <option value="#xf143;" {{ $metric->info_box_icon ===
                                                                    "#xf143;" ? 'selected':''}}>&#xf143; </option>
                                                                <option value="#xf158;" {{ $metric->info_box_icon ===
                                                                    "#xf158;" ? 'selected':''}}>&#xf158; </option>
                                                                <option value="#xf158;" {{ $metric->info_box_icon ===
                                                                    "#xf158;" ? 'selected':''}}>&#xf158; </option>
                                                                <option value="#xf156;" {{ $metric->info_box_icon ===
                                                                    "#xf156;" ? 'selected':''}}>&#xf156; </option>
                                                                <option value="#xf267;" {{ $metric->info_box_icon ===
                                                                    "#xf267;" ? 'selected':''}}>&#xf267; </option>
                                                                <option value="#xf1de;" {{ $metric->info_box_icon ===
                                                                    "#xf1de;" ? 'selected':''}}>&#xf1de; </option>
                                                                <option value="#xf1e7;" {{ $metric->info_box_icon ===
                                                                    "#xf1e7;" ? 'selected':''}}>&#xf1e7; </option>
                                                                <option value="#xf118;" {{ $metric->info_box_icon ===
                                                                    "#xf118;" ? 'selected':''}}>&#xf118; </option>
                                                                <option value="#xf0de;" {{ $metric->info_box_icon ===
                                                                    "#xf0de;" ? 'selected':''}}>&#xf0de; </option>
                                                                <option value="#xf0dd;" {{ $metric->info_box_icon ===
                                                                    "#xf0dd;" ? 'selected':''}}>&#xf0dd; </option>
                                                                <option value="#xf0dd;" {{ $metric->info_box_icon ===
                                                                    "#xf0dd;" ? 'selected':''}}>&#xf0dd; </option>
                                                                <option value="#xf110;" {{ $metric->info_box_icon ===
                                                                    "#xf110;" ? 'selected':''}}>&#xf110; </option>
                                                                <option value="#xf1b1;" {{ $metric->info_box_icon ===
                                                                    "#xf1b1;" ? 'selected':''}}>&#xf1b1; </option>
                                                                <option value="#xf1bc;" {{ $metric->info_box_icon ===
                                                                    "#xf1bc;" ? 'selected':''}}>&#xf1bc; </option>
                                                                <option value="#xf0c8;" {{ $metric->info_box_icon ===
                                                                    "#xf0c8;" ? 'selected':''}}>&#xf0c8; </option>
                                                                <option value="#xf096;" {{ $metric->info_box_icon ===
                                                                    "#xf096;" ? 'selected':''}}>&#xf096; </option>
                                                                <option value="#xf005;" {{ $metric->info_box_icon ===
                                                                    "#xf005;" ? 'selected':''}}>&#xf005; </option>
                                                                <option value="#xf089;" {{ $metric->info_box_icon ===
                                                                    "#xf089;" ? 'selected':''}}>&#xf089; </option>
                                                                <option value="#xf04d;" {{ $metric->info_box_icon ===
                                                                    "#xf04d;" ? 'selected':''}}>&#xf04d; </option>
                                                                <option value="#xf12c;" {{ $metric->info_box_icon ===
                                                                    "#xf12c;" ? 'selected':''}}>&#xf12c; </option>
                                                                <option value="#xf10a;" {{ $metric->info_box_icon ===
                                                                    "#xf10a;" ? 'selected':''}}>&#xf10a; </option>
                                                                <option value="#xf0e4;" {{ $metric->info_box_icon ===
                                                                    "#xf0e4;" ? 'selected':''}}>&#xf0e4; </option>
                                                                <option value="#xf02b;" {{ $metric->info_box_icon ===
                                                                    "#xf02b;" ? 'selected':''}}>&#xf02b; </option>
                                                                <option value="#xf02c;" {{ $metric->info_box_icon ===
                                                                    "#xf02c;" ? 'selected':''}}>&#xf02c; </option>
                                                            </select>
                                                        </div>

                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                                <div class="row"></div>
                            </div>
                            <div class="tab-pane" id="setup">
                                <div class="row"></div>

                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <h5 style="color: #67b0ca">
                                                <b>Metric Settings</b>
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                                <form action="#" id="metric-setup-form"
                                    data-url="{{ route('metrics.wizard.setting.update',$metric->id) }}">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <label>Metric Name</label>
                                                <span class="glyphicon glyphicon-info-sign" style="color: #68b3c8"
                                                    data-toggle="tooltip"
                                                    data-title="Unique Metric Name Required: Smart Report categorizes charts, reports, metrics, and other modules as 'Analytical Resources.' Each analytical resource, regardless of its type, must have a distinct name. Therefore, please ensure that the Metrics name you provide is unique."></span>
                                                <input id="metric-name" name="name" type="text"
                                                    class="form-control username" placeholder=""
                                                    value="{{ $metric->name }}" />
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <label>Metric Title</label>
                                                <span class="glyphicon glyphicon-info-sign" style="color: #68b3c8"
                                                    data-toggle="tooltip"
                                                    data-title="Title Required for Metrics: Please include a title for this Metric. This title will be prominently showcased on the generated Metric, offering vital context and information to viewers.">
                                                </span>
                                                <input id="title" name="title" type="text" class="form-control username"
                                                    placeholder="" value="{{ $metric->getResourceConfiguration('title')
                                                    }}" />
                                            </div>
                                        </div>

                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <label> Metric Category </label>
                                                <span class="glyphicon glyphicon-info-sign"
                                                    style="color: #68b3c8; margin-left: 5px" data-toggle="tooltip"
                                                    data-title="Category Selection Required: Please choose the category to which the Metric belongs. This helps organize and classify the Metrics appropriately for easy retrieval and navigation."></span>

                                                <select id="category" name="category" class="form-control"
                                                    placeholder="">
                                                    <option value="">Please Choose Category</option>
                                                    @foreach ($categories as $category)
                                                    <option value="{{ $category->id }}" @if($metric->category_id ==
                                                        $category->id) {{ "selected" }} @endif>{{ $category->name }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <label> Metric Date Connection </label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Data Connection Selection: Please select the data connection through which Smart Report Maker can access the necessary data for generating the Metric. This ensures that the correct data source is utilized to produce  relevant visualizations."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <label class="form-control" id="connection" @if(isset($metric->
                                                    data_connection_id))
                                                    data-url="{{
                                                    route('data_connections.getTables',$metric->data_connection_id) }}"
                                                    @else
                                                    data-url="{{ route('data_connections.getTables','default') }}"
                                                    @endif

                                                    @if(isset($metric->data_connection))
                                                    data-connection="{{ $metric->data_connection_id }}"
                                                    @else
                                                    data-connection="default"
                                                    @endif

                                                    >
                                                    @if(isset($metric->data_connection))
                                                    {{$metric->data_connection->connection_name }}
                                                    @else
                                                    {{ "default" }}
                                                    @endif
                                                </label>

                                            </div>
                                        </div>

                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <label> Metric Security Type </label><span
                                                    class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Security Type Selection: Decide on the security level for your Metric. Opt for 'Private' to limit access to logged-in users from designated groups. Alternatively, opt for 'Public' to grant access to the metric and its detailed drill-down data to anyone, irrespective of their login status."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <select id="security-type" name="security_type" class="form-control"
                                                    placeholder="">
                                                    <option value="">Please Choose Security type</option>
                                                    <option value="private" @if(strtolower($metric->access_control_type)
                                                        == "private") {{ "selected" }} @endif>Private</option>
                                                    <option value="public" @if(strtolower($metric->access_control_type)
                                                        == "public") {{ "selected" }} @endif>Public</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <label> Metric Group </label><span class="glyphicon glyphicon-info-sign"
                                                    data-toggle="tooltip"
                                                    data-title="Group Selection: If the security type is set to private, please select the groups whose users will have access to this Metric. Only members of the selected groups will be able to view the Metric."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <select multiple id="groups" name="groups[]" class="form-control"
                                                    placeholder="">
                                                    @foreach ($groups as $group)
                                                    <option value="{{ $group->group_ID }}" @if($metric->
                                                        resource_permissions->contains('group_ID', $group->group_ID))
                                                        selected
                                                        @endif


                                                        >{{ $group->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group"></div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane" id="data">
                                <form action="#" id="metric-data-form"
                                    data-url="{{ route('metrics.wizard.data.update',$metric->id) }}">
                                    @csrf
                                    <div class="row"></div>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <h5 style="color: #67b0ca"><b>Metric / KPI data settings</b></h5>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <label>Performance data table</label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Choose the database table containing performance data from which you wish to calculate the Metric / KPI."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <select class="form-control" id="performance-data-table"
                                                    name="performance_data_table"
                                                    data-url="{{ route('data_connections.index') }}">
                                                    <option value="">Please Select Table</option>
                                                    @foreach ($tables as $table)
                                                    <option value="{{ $table }}" @if($table==$metric->
                                                        getResourceConfiguration('performance_data_table')) {{
                                                        'selected' }} @endif>{{
                                                        $table }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <label>Calculation column</label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="Choose the column to which you want to apply the calculation function. It should typically be a numeric column, except when selecting the 'count' function."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                                <select class="form-control" id="calculation-column"
                                                    name="calculation_column"
                                                    data-url="{{ route('data_connections.index') }}">
                                                    <option value="">Please Select Column</option>
                                                    @foreach ($columns as $column)
                                                    <option value="{{ $column }}" @if($column==$metric->
                                                        getResourceConfiguration('calculation_column')) {{ 'selected' }}
                                                        @endif>{{
                                                        $column }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div>
                                            <div class="col-sm-5 col-sm-offset-1">
                                                <div class="form-group">
                                                    <label>Calculation function</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="The calculation function defines the operation to be performed on the calculation column to determine the value of the Metric."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <select class="form-control" id="function" name="function">
                                                        <option value="distinct_count" @if($metric->
                                                            getResourceConfiguration('function') =="distinct_count") {{
                                                            'selected' }}
                                                            @endif>Count Distinct</option>
                                                        <option value="count" @if($metric->
                                                            getResourceConfiguration('function') =="count") {{
                                                            'selected' }}
                                                            @endif>Count All</option>
                                                        <option value="conditional_count" @if($metric->
                                                            getResourceConfiguration('function') =="conditional_count")
                                                            {{
                                                            'selected' }}
                                                            @endif>Conditional Count</option>

                                                        <option value="sum" @if($metric->
                                                            getResourceConfiguration('function') =="sum") {{ 'selected'
                                                            }}
                                                            @endif>Sum</option>
                                                        <option value="conditional_sum" @if($metric->
                                                            getResourceConfiguration('function') =="conditional_sum")
                                                            {{
                                                            'selected' }}
                                                            @endif>Conditional Sum</option>

                                                        <option value="average" @if($metric->
                                                            getResourceConfiguration('function') =="average") {{
                                                            'selected'
                                                            }}
                                                            @endif>Average</option>
                                                        <option value="conditional_average" @if($metric->
                                                            getResourceConfiguration('function')
                                                            =="conditional_average")
                                                            {{
                                                            'selected' }}
                                                            @endif>Conditional Average</option>

                                                        <option value="max" @if($metric->
                                                            getResourceConfiguration('function') =="max") {{ 'selected'
                                                            }}
                                                            @endif>Max</option>
                                                        <option value="conditional_max" @if($metric->
                                                            getResourceConfiguration('function')
                                                            =="conditional_max")
                                                            {{
                                                            'selected' }}
                                                            @endif>Conditional Max</option>

                                                        <option value="min" @if($metric->
                                                            getResourceConfiguration('function') =="min") {{ 'selected'
                                                            }}
                                                            @endif>Min</option>
                                                        <option value="conditional_min" @if($metric->
                                                            getResourceConfiguration('function')
                                                            =="conditional_min")
                                                            {{
                                                            'selected' }}
                                                            @endif>Conditional Min</option>


                                                        <option value="sample-standard-deviation">Sample Standard
                                                            Deviation
                                                        </option @if($metric->
                                                        getResourceConfiguration('function')
                                                        =="sample-standard-deviation")
                                                        {{ 'selected' }}
                                                        @endif>
                                                        <option value="population-standard-deviation" @if($metric->
                                                            getResourceConfiguration('function')
                                                            =="population-standard-deviation") {{ 'selected' }}
                                                            @endif>Population Standard Deviation</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-sm-5">
                                                <div class="form-group">
                                                    <label>Metric Direction</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="This field allows you to specify the directionality of the metric. You can either select the 'Increase is Better' option if the metric, such as sales, is considered favorable when it increases, or select the 'Decrease is Better' option if the metric, such as the number of failed orders, is considered favorable when it decreases. By selecting the appropriate directionality, you ensure that the system interprets and presents the metric's performance correctly."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <select class="form-control" id="metric-direction"
                                                        name="metric_direction">
                                                        <option value="increase" @if($metric->
                                                            getResourceConfiguration('metric_direction') == "increase")
                                                            {{ "selected" }} @endif>Increase is Better</option>
                                                        <option value="decrease" @if($metric->
                                                            getResourceConfiguration('metric_direction') == "decrease")
                                                            {{ "selected" }} @endif>Decrease is Better</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="filter-container" @if(!is_null($metric->
                                            getResourceConfiguration('function')) &&in_array($metric->
                                            getResourceConfiguration('function'),["conditional_count",
                                            "conditional_sum", "conditional_average", "conditional_max",
                                            "conditional_min" ])) @else style="display: none" @endif>
                                            <div class="col-sm-5 col-sm-offset-1">
                                                <div class="form-group">
                                                    <label>Filtration column</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="When selecting a conditional function like Conditional Count, you must choose a column for filtering. For example, to count female employees, the counted column would be 'employee ID', while the filter column would be 'gender', and the filter value would be 'female' to count only female employees. In this field, you need to select the filtration column."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <select class="form-control" id="filtration-column"
                                                        name="filtration_column">
                                                        <option value="">Please Select Filtration Column</option>
                                                        @foreach ($columns as $column)

                                                        <option value="{{ $column }}" @if($column==$metric->
                                                            getResourceConfiguration('filtration_column')) {{ 'selected'
                                                            }}
                                                            @endif>{{
                                                            $column }}
                                                        </option>
                                                        @endforeach

                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-5">
                                                <div class="form-group">
                                                    <label>Filtration Value</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="When selecting a conditional function like Conditional Count, you must choose a column for filtering. For example, to count female employees, the counted column would be 'employee ID', while the filter column would be 'gender', and the filter value would be 'female' to count only female employees. In this field, you need to select the filtration value."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <input type="text" id="filteration-value" class="form-control"
                                                        name="filtration_value"
                                                        value="{{ $metric->getResourceConfiguration('filtration_value') }}">
                                                </div>
                                            </div>
                                        </div>


                                        <div>
                                            <div class="col-sm-5 col-sm-offset-1">
                                                <div class="form-group">
                                                    <label>Date Filter column</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="This column serves as the date field utilized for data filtration, enabling the filtering of data by specific dates. It is instrumental when applying date filtration to estimate Metric values within defined date ranges."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <select class="form-control" id="date-filter-column"
                                                        name="date_filter_column">
                                                        <option value="">Please Select Column</option>
                                                        @foreach ($dateTimeColumns as $column)
                                                        <option value="{{ $column }}" @if($column==$metric->
                                                            getResourceConfiguration('date_filter_column')) {{
                                                            'selected' }}
                                                            @endif>{{
                                                            $column }}
                                                        </option>
                                                        @endforeach

                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-5">
                                                <div class="form-group">
                                                    <label>Date range</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="The date range specifies the period for estimating the Metric. Selecting 'All Time' implies no filtration, utilizing all stored data for estimating the Metric value."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <select class="form-control" id="date-range" name="date_range"
                                                        @if(count($dateTimeColumns) <=0) disabled="disabled" @endif>
                                                        @foreach ($dateRanges as $range)
                                                        <option value="{{ $range['value'] }}" @if($metric->
                                                            getResourceConfiguration('date_range') == $range['value'])
                                                            {{ "selected" }}@endif>{{ $range['label'] }}
                                                        </option>

                                                        @endforeach

                                                    </select>
                                                    <input type="hidden" id="date-range-hidden" name="date_range"
                                                        value="all_time" @if(count($dateTimeColumns)> 0)
                                                    disabled="disabled" @endif>

                                                </div>
                                            </div>
                                        </div>
                                        <div>
                                            <div class="col-sm-5 col-sm-offset-1">
                                                <div class="form-group">
                                                    <label>Display Format</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="Select your preferred display format for the Metric. You have the option to display it solely as a numerical value, with a custom measuring unit or currency appended, or as a percentage. Please note that the percentage option should only be selected if the stored value in the database accurately represents a percentage."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <select class="form-control" id="display-format"
                                                        name="display_format">
                                                        <option value="numeric" @if($metric->
                                                            getResourceConfiguration('display_format') == "numeric") {{
                                                            "selected" }}@endif>Numeric Value</option>
                                                        <option value="compact_currency" @if($metric->
                                                            getResourceConfiguration('display_format') ==
                                                            "compact_currency") {{
                                                            "selected" }}@endif>Compact Currency Format</option>
                                                        <option value="standard_currency" @if($metric->
                                                            getResourceConfiguration('display_format') ==
                                                            "standard_currency") {{
                                                            "selected" }}@endif>Standard Currency Format</option>

                                                        <option value="numeric_with_custom_unit" @if($metric->
                                                            getResourceConfiguration('display_format') ==
                                                            "numeric_with_custom_unit") {{ "selected" }}@endif>Custom
                                                            Unit</option>
                                                        <option value="percentage" @if($metric->
                                                            getResourceConfiguration('display_format') == "percentage")
                                                            {{ "selected" }}@endif>Percentage</option>

                                                        <option value="percentage_of_total" @if($metric->
                                                            getResourceConfiguration('display_format') ==
                                                            "percentage_of_total")
                                                            {{ "selected" }}@endif class="conditional-only">Percentage
                                                            Of Total</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-5">
                                                <div class="form-group">
                                                    <label>Custom Unit or Currency</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="any measurement unit, currency, or any other text you wish to append to the metric."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <input type="text" class="form-control" name="custom_unit_input"
                                                        id="custom-unit-input" placeholder=""
                                                        @if(!is_null($metric->getResourceConfiguration('custom_unit_input')))
                                                    value="{{ $metric->getResourceConfiguration('custom_unit_input') }}"
                                                    @endif/>
                                                </div>
                                            </div>
                                        </div>
                                        <div>
                                            <div class="col-sm-5 col-sm-offset-1">
                                                <div class="form-group">
                                                    <label>Compare with</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="Enable comparison between the current metric value, either with an exact fixed target value or a historical value, which requires selecting the reference point for comparison. You can choose either 'Same Time Last Year,' which aligns the selected day, month, or week with its equivalent time in the preceding year, or 'Preceding Period,' which compares with the day, week, or month immediately preceding."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <select class="form-control" id="compare-with" name="compare_with">
                                                        <option value="no_comparison" @if($metric->
                                                            getResourceConfiguration('compare_with') == "no_comparison")
                                                            {{ "selected" }}@endif>No Comparison</option>
                                                        <option value="compare_with_preceding_period" @if($metric->
                                                            getResourceConfiguration('compare_with') ==
                                                            "compare_with_preceding_period")
                                                            {{ "selected" }}@endif>Compare With Preceding Period
                                                        </option>
                                                        <option value="compare_with_same_time_last_year" @if($metric->
                                                            getResourceConfiguration('compare_with') ==
                                                            "compare_with_same_time_last_year")
                                                            {{ "selected" }}@endif>Compare with Same Time Last Year
                                                        </option>
                                                        <option value="compare_with_a_fixed_target_value" @if($metric->
                                                            getResourceConfiguration('compare_with') ==
                                                            "compare_with_a_fixed_target_value")
                                                            {{ "selected" }}@endif>Compare With a
                                                            Fixed Target Value</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-5">
                                                <div class="form-group">
                                                    <label>Target Value Input</label>
                                                    <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="The target value against which you wish to compare your KPI/Metric."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <input type="text" class="form-control" name="target_value_input"
                                                        id="target-value-input" placeholder=""
                                                        @if(!is_null($metric->getResourceConfiguration('target_value_input')))
                                                    value="{{ $metric->getResourceConfiguration('target_value_input')
                                                    }}"
                                                    @endif/>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-sm-5 col-sm-offset-1">
                                            <div class="form-group">
                                                <input class="form-check-input" type="checkbox" id="drill-down"
                                                    name="drill_down"
                                                    @if($metric->getResourceConfiguration("drill_down"))
                                                {{ "checked" }}
                                                @endif
                                                />
                                                <label> Enable Drill Down </label>
                                                <span class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                    data-title="The 'drill-down' feature empowers users to delve deeper into the data, uncovering detailed insights related to the metric. For instance, if your metric involves counting orders, enabling drill-down functionality allows users to access individual order details used in the calculation by simply clicking on the metric."
                                                    style="color: #68b3c8; margin-left: 5px">
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="form-group">
                                                <div class="form-group">
                                                    <label>Drill Down Columns</label><span
                                                        class="glyphicon glyphicon-info-sign" data-toggle="tooltip"
                                                        data-title="Choose the columns to be displayed in the detailed report to which users will be directed when they clicking on this metric."
                                                        style="color: #68b3c8; margin-left: 5px">
                                                    </span>
                                                    <select multiple id="drill-down-columns" name="drill_down_columns[]"
                                                        class="form-control" placeholder="">
                                                        @foreach($columns as $column)
                                                        <option value="{{ $column }}" @if($column==collect($metric->
                                                            getResourceConfiguration("drill_down_columns"))->contains(
                                                            $column)) {{
                                                            'selected' }}
                                                            @endif>{{
                                                            $column }}
                                                        </option>
                                                        @endforeach

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="wizard-footer">

                                <div class="text-center">
                                    <label id="error" style="display: none;font-size:1em;color:red" class="error"
                                        data-toggle="tooltip" data-title="" for="confirmpassword">

                                    </label>

                                </div>
                                <div class="pull-right">
                                    <!-- Finish Button -->
                                    <input type="button" class="btn btn-finish btn-fill btn-warning btn-wd"
                                        name="finish" value="Finish" style="display: none" />

                                    <input type="button" class="btn btn-next btn-fill btn-warning btn-wd type-step"
                                        name="next" value="Next" />
                                </div>
                                <div class="pull-left">
                                    <input type="button" class="btn btn-previous btn-default btn-wd disabled"
                                        name="previous" value="Previous" />
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- wizard container -->
            </div>
        </div>
        <!-- row -->
    </div>
</div>

@endsection

@section('scripts')

@if(!checkDemo())
<script src="{{ get_asset('dist/js/metrics/edit.js')}}"></script>
@else
<script src="{{ get_asset('dist/js/alertify.min.js')}}"></script>
<script src="{{ get_asset('dist/js/metrics/demo.js')}}"></script>
@endif
@endsection
