@extends('layouts.app')

@section('styles')
<style>
    .content-wrapper>* {
        font-family: 'poppins', 'arial';
    }
</style>

@endsection

@section('content')

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid px-4">
            <div class="row mt-2">
                <div class="col-sm-6">
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('charts.index') }}">Charts</a></li>
                        <li class="breadcrumb-item">{{ $chart->name }}</li>
                    </ol>
                </div>
            </div>
            <div class="row mb-2 mt-2">
                <div class="col-sm-8">
                    <h2 style="font-weight: bold">{{ ucwords($chart->getResourceConfiguration('title')) }}
                    </h2>
                    <h6>{{ $chart->created_at->format('d M Y h:i A') }}</h6>
                </div>
                <div class="col-sm-4 text-right">
                    <div class="p-2 branding-logo">
                        @include('partials._logo')
                    </div>
                </div>
            </div>
            <hr style="border-top: 1px solid rgba(0, 0, 0, .5);">
        </div>
        <div class="container-fluid mt-4 px-4" style="min-height:60vh">
            <div class="row">
                <div class="col-6">
                    @if(is_array($label))
                    <h6 class="py-3" style="font-weight:bold">{{
                        ucwords($chart->getResourceConfiguration('x_axis_column')) }}
                        : <span class="text-primary " style="font-weight:normal">{{ $label[0]
                            }}</span> to
                        <span class="text-primary" style="font-weight:normal">{{
                            $label[1] }}</span>
                    </h6>
                    @else
                    <h6 class="py-3" style="font-weight:bold">{{
                        ucwords($chart->getResourceConfiguration('x_axis_column')) }}
                        : <span class="text-primary" style="font-weight:normal">{{ ucwords($xValue) }}</span>
                    </h6>
                    @endif
                </div>

                <div class="col-6">
                    <div class="buttons text-right mb-4">
                        <a href="{{ route('charts.drill.print',[$chart->id]).'?xValue=' . $xValue .'&page=' . $data->currentPage() }}"
                            id="print-chart" class="btn btn-light py-3 px-4 btn-xl shadow-sm mx-4"
                            style="display: inline-block">
                            <i class="fa-solid fa-print"></i> Print
                        </a>
                        <a href="{{ route('charts.drill.export',[$chart->id]).'?xValue=' . $xValue .'&page=' . $data->currentPage()}}"
                            id="export-chart" class="btn btn-light py-3 px-3 shadow-sm" style="display: inline-block">
                            <i class="fa-solid fa-file-export"></i> Export
                        </a>
                    </div>
                </div>

            </div>
            <div class="clearfix"></div>

            <div class="table table-bordered table-striped" style="overflow-x: auto;word-break:keep-all;">
                <table id="reports" style="width: 100%">
                    <thead>
                        <tr style="background-color: #d6d8da">
                            @foreach($keys as $key)
                            <th>{{ ucwords($key) }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @if($data->total() > 0)
                        @foreach($data as $row)
                        <tr class="smaller-font">
                            @foreach($row as $item)

                            <td>{{ $item }}</td>
                            @endforeach
                        </tr>
                        @endforeach
                        @else
                        <tr style="background-color:transparent">
                            <td style="text-align: center" colspan="{{ count($keys) }}">
                                <h6>Sorry, There is no data</h6>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
        <div class="float-right">
            {{ $data->appends(request()->query())->links() }}
        </div>
        <div class="clearfix"></div>

</div>


@endsection


@section('scripts')

<script>
    $(document).on('click','#export-chart',function(e){
        e.preventDefault();
        $.ajax({
            type: 'GET',
            url: $("#export-chart").attr('href'),
            xhrFields:{
                responseType: 'blob'
            },
            beforeSend:function(){
                $("#global-loader").fadeIn();
                $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

            },
            success: function(response) {
                var blob = new Blob([response]);
                var link = document.createElement('a');
                link.href = URL.createObjectURL(blob);
                link.download = "{{ ucwords($chart->getResourceConfiguration('title')) }}-{{ $formatedXValue }}-page {{ $data->currentPage() }}.pdf";
                link.click();

                $("#global-loader").fadeOut("slow");
                $("#global-loader .loader-text").html('');

            },
            error: function(xhr, status, error) {
                console.error(error);
            }
        });

    });

    $(document).on('click','#print-chart',function(e){
        e.preventDefault();
        $("#global-loader .loader-text").html('Please wait, this may take a few minutes.');

        window.location.href = $("#print-chart").attr('href')

    });

</script>

@endsection