$(document).ready(function () {

    $("#saveBtn-smtp-server").attr("disabled", true);


    //add data connection
    $(".container-fluid").on("click", "#saveBtn-general-settings", function () {
        let fields = ["from_name", "from_email", "mail_signature", "timezone", "username", "cronjobs_created"];
        sendAjaxRequest("general-settings-form", fields, "confirm-general-settings", "error-general-settings");

    });

    $(".container-fluid").on("click", "#cancelBtn-general-settings", function () {
        reloadForm("general-settings-form");
        $('#error-general-settings, #confirm-general-settings').hide();

    });


    // test connection
    $(".container-fluid").on("click", "#test-smtp-server-connection", function () {
        let fields = ["smtp_server", "smtp_port", "username", "password", "encryption", "auth_mode"];
        sendTestSMTPConnectionAjaxRequest("smtp-server-form", "test-smtp-server-connection", fields, "confirm-smtp-server", "error-smtp-server");
    });



    //save smtp connection
    $(".container-fluid").on("click", "#saveBtn-smtp-server", function () {
        let fields = ["smtp_server", "smtp_port", "username", "password", "encryption", "auth_mode"];
        sendSMTPConnectionAjaxRequest("smtp-server-form", fields, "confirm-smtp-server", "error-smtp-server");

    });

    $(".container-fluid").on("click", "#cancelBtn-smtp-server", function () {
        reloadForm("smtp-server-form");
        $('#error-smtp-server, #confirm-smtp-server').hide();

    });

    $("#smtp-confirm-modal").on("click", "#saveBtn-smtp-confirm", function () {

        var form = document.getElementById("smtp-server-form");
        var allData = new FormData(form);
        allData.append('confirmed', true);

        $.ajax({
            type: "POST",
            url: $('#smtp-server-form').data('url'),
            data: allData,
            contentType: false,
            processData: false,
            dataType: "json",
            beforeSend: function () {
                $("#global-loader").css('opacity', '0.5');
                $("#global-loader").fadeIn();
            },
            success: function (response) {
                $(`#confirm-smtp-server`).text(response.message).show();
                $(`#error-smtp-server`).hide();

            },
            error: function (response) {
                response = response.responseJSON;

                if (response.message) {
                    $(`#error-smtp-server`).text(response.message).show();
                    $(`#confirm-smtp-server`).hide();
                }
                if (response.errors) {
                    fields.every(error => {
                        if (response.errors[error]) {

                            $(`#error-smtp-server`).text(response.errors[error][0]).show();

                            $(`#confirm-smtp-server`).hide();

                            return false;
                        }
                        return true;

                    });

                }

                $("#global-loader").css('opacity', '1');

                $("#global-loader").fadeOut();

                $(`#confirm-smtp-server`).hide();
            },
            complete: function () {
                $('#smtp-confirm-modal').modal('hide')
                $("#global-loader").css('opacity', '1');

                $("#global-loader").fadeOut();
            },
        });

    });

});
