$(document).ready(function () {

    $(".container-fluid").on("click", ".add-dataconnection-button", function () {
        reloadForm("add-dataconnection-form");
    });

    $('#add-dataconnection-modal').on('hidden.bs.modal', function () {
        reloadForm("add-dataconnection-form");

        $("#error-add-dataconnection").hide();

        $("#confirm-add-dataconnection").hide();
    });

    // delete data connections modal
    $('#data-connections').on('click', ".delete-data-connection", function (event) {
        let user_name = $(this).closest('tr').find('td:first').text();
        $('#delete-data-connection-modal').find('.modal-body p').text(`Are you sure you want to delete "${user_name}"?`)
        $('#delete-data-connection-form').attr('data-url', $(this).attr('data-url'))
    });


    $("#delete-data-connection-form").on("click", "#saveBtn-delete-data-connection", function () {

        sendAjaxRequestWithSuccess("delete-data-connection-form", 'delete-data-connection-modal', reloadDataConnectionTable, ["data-connections"]);

    });

    // test connection
    $("#add-dataconnection-modal").on("click", "#test-add-dataconnection", function () {
        let fields = ["connection_name", "database_type", "server", "database", "username", "password", "port", "charset", "collation"];
        sendTestConnectionAjaxRequest("add-dataconnection-form", "test-add-dataconnection", fields, "confirm-add-dataconnection", "error-add-dataconnection", afterTestConnectionSuccess);
    });


    //add data connection
    $("#add-dataconnection-modal").on("click", "#saveBtn-add-dataconnection", function () {
        let fields = ["connection_name", "database_type", "server", "database", "username", "password", "port", "charset", "collation"];
        sendAjaxRequest("add-dataconnection-form", fields, "confirm-add-dataconnection", "error-add-dataconnection", reloadDataConnectionTable, ["data-connections"]);

        $('#add-dataconnection-modal').on('hidden.bs.modal', function () {
            reloadForm("add-dataconnection-form");
            $("#error-add-dataconnection").hide();

            $("#confirm-add-dataconnection").hide();

        });


    });

    $("#add-dataconnection-modal").on("click", "#cancelBtn-add-dataconnection", function () {
        reloadForm("add-dataconnection-form");

        $('#error-add-dataconnection, #confirm-add-dataconnection').hide();

    });


    // edit data connection

    $('#data-connections').on('click', ".edit-dataconnection", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                $('#edit-dataconnection-modal-container').html(response);
                $('#edit-dataconnection-modal').modal('show');

                $("#edit-dataconnection-modal-container").on("click", "#test-edit-dataconnection", function () {
                    $('#edit-dataconnection-modal-container input[name="_method"]').val("POST");
                    let fields = ["connection_name", "database_type", "server", "database", "username", "password", "port", "charset", "collation"];
                    sendTestConnectionAjaxRequest("edit-dataconnection-form", "test-edit-dataconnection", fields, "confirm-edit-dataconnection", "error-edit-dataconnection", afterEditTestConnectionSuccess);
                });


                $("#edit-dataconnection-modal-container").on("click", "#saveBtn-edit-dataconnection", function () {

                    let fields = ["connection_name", "database_type", "server", "database", "username", "password", "port", "charset", "collation"];
                    sendAjaxRequest("edit-dataconnection-form", fields, "confirm-edit-dataconnection", "error-edit-dataconnection", reloadDataConnectionTable, ["data-connections"]);
                });

                $("#edit-dataconnection-modal-container").on("click", "#cancelBtn-edit-dataconnection", function () {
                    reloadForm("edit-dataconnection-form");
                    $('#error-edit-dataconnection, #confirm-edit-dataconnection').hide();

                });


            },
        });

    });



});
