$(document).ready(function () {

    $('#error').hide();
    $('#success').hide();

    $('#resetPassword').on('click', function () {
        resetPassword();
    });


});


function resetPassword() {

    var resetform = document.getElementById("resetpasswordform");
    let resetPasswordUrl = $('#resetpasswordform').attr('data-reset');

    $.ajax({
        type: "POST",
        url: resetPasswordUrl,
        data: new FormData(resetform),
        contentType: false,
        processData: false,
        dataType: "json",
        success: function (response) {
            if (response.message) {
                $('#success').text(response.message).show();
                $('#error').hide();
                $('.form').slideUp();

            }
            if (response.demo) {
                $(`#demo-modal`).find('h5').text(response.demo).show();
                $(`#demo-modal`).modal('show');
            }


        },
        error: function (response) {

            response = response.responseJSON;
            if (response.errors.email)
                $('#error').text(response.errors.email[0]).show();
            if (response.errors.password)
                $('#error').text(response.errors.password[0]).show();

            if (response.errors.password_confirmation)
                $('#error').text(response.errors.password_confirmation[0]).show();

            $('#success').hide();

            shakeModal();

        }
    });

}



function shakeModal() {
    $('#resetPassword .modal-dialog').addClass('shake');
    // $('input[type="password"]').val('');
    setTimeout(function () {
        $('#resetPassword .modal-dialog').removeClass('shake');
    }, 1000);
}

$('#resetPasswordModal').modal({ backdrop: 'static', keyboard: false });




