<?php

//defined('ACCESS') or die("No direct access allowed!");

return [
    /*
    |--------------------------------------------------------------------------
    | Installer settings
    |--------------------------------------------------------------------------
    |
    | All settings related to the installer wizard which includes
    | the redirection after finishing the wizard
    | if we need a settings step
    | Directories that require read/write permissions

    | the cronjob settings
    |
     */
    'installer'          => [
        "version_to_install"      => "v9.1.10",
        "installation_method"     => "composer",
        "redirect"                => "/",
        "min_supported_version"   => "81",
        "install_dir"             => "srm_install",
        "debug_mode"              => false,
        "php_version_warning"     => "Your PHP version is {user_PHP_Version}, while we support PHP {Min_supported_version} or later. We advise you to upgrade your PHP version before installing Smart Report Maker to ensure that all its features work as intended.",
        "data_sources"            => ["mysql"],
        "allow_smtp_later"        => 1,
        "is_settings_step_needed" => 1,
        "cronjob"                 => [
            "dashboard/scheduler.php",
            "dashboard/worker.php"
        ],
        "read_write_directories"  => [
            "srm",
            "srm/modules/SRM9/SRM/Reports9",
            "srm/dashboard/",
            "srm/dashboard/public/",
            "srm/dashboard/config/",
            "srm/dashboard/storage/logs"
        ],
        "table_prefix"            => "srm_",
        "final_message"           => "Installation of Smart Report Maker has been successfully completed. Please click the 'Launch Smart Report Maker' button to be redirected to the dashboard.",
        "final_message_docker"    => "Installation of Smart Report Maker has been successfully completed. Please click the 'Launch Smart Report Maker' button to be redirected to the dashboard."
    ],
    'login'              => [
        'max_login_failure_attempts'           => 5,
        'lockout_duration_minutes'             => 30,
        'rememeber_me_token_life_span_days'    => 30,
        'reset_password_token_life_span_hours' => 24
    ],
    'dashboard'          => [
        "security_questions"              => [
            "What was the name of your favorite childhood pet?",
            "What is your mother’s middle name? ",
            "What is your child’s nickname? ",
            "What year did you enter college?",
            "In which city did your parents meet?",
            "What year was your father born?"
        ],
        "dashboard_data_connections"      => [
            "Mysql"
        ],
        "organization_logo"               =>
        [
            "width"  => 234,
            "height" => 100
        ],
        "system_logo"                     =>
        [
            "width"  => 369,
            "height" => 71
        ],
        "charts_per_page"                 => 6,
        "metrics_per_page"                => 40,
        "max_home_widgets"                => 20,
        "max_dashboard_widgets"           => 20,
        "report_display"                  => "inside_page",
        "drill_down_max_records_per_page" => 25
    ],
    'security_message'   => "Security Alert: The .htaccess file shipped with Smart Report Maker doesn't seem to have prevented direct access to sensitive configuration files, which should be prohibited. Please configure your web server (whether it's Apache, IIS, or Nginx) to ensure that files starting with a dot (e.g., .htaccess, .env) and certain config file types (e.g., *.json, *.xml, *.config, *.yml, *.log) are not directly accessible.",
    "send_curl_requests" => 1,
    "core"               => [],
    "srm"                => [],
    "src"                => []
];
