<?php

namespace App\Mails;

use App\Mails\SendMail;
use App\Mails\MailTrait;
use App\Mails\MailInterface;

class ResetPasswordMail implements MailInterface
{
    use MailTrait;

    public $user;
    public $token;

    private $subject;
    private $content;
    private $username;
    private $signature;
    private $headers;
    private $receiver;

    public function __construct($user, $token)
    {
        $this->user  = $user;
        $this->token = $token;
    }

    public function send()
    {
        $this->buildMailMessage("Reset your account password");

        SendMail::mail(
            $this->receiver,
            $this->subject,
            $this->content,
            $this->headers,
        );
    }

    /**
     * Set the value of content
     */
    public function setMessageContent()
    {
        $username  = $this->username;
        $signature = $this->signature;
        $resetUrl  = $this->resetUrl($this->user);

        $this->content = view(
            'auth.mails.reset',
            compact('username', 'resetUrl', 'signature')
        )->render();
    }

    private function resetUrl($user)
    {
        return url(route('password.reset', [
            'token' => $this->token
        ], false));
    }
}
