<?php

namespace App\Mails;

use App\Mails\SendMail;
use App\Mails\MailTrait;
use App\Mails\MailInterface;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Config;
use App\Exceptions\SystemErrorException;
use Illuminate\Validation\ValidationException;

class EmailChangedConfirmation implements MailInterface
{
    use MailTrait;

    public $user;
    private $subject;
    private $content;
    private $username;
    private $signature;
    private $headers;
    private $receiver;

    private $new_email;
    public function __construct($user, $new_email)
    {
        $this->user = $user;
        $this->new_email = $new_email;
    }

    public function send()
    {
        $this->buildMailMessage("Your Smart Report Maker Email address was edited!");


        $this->setReceivcer($this->user->Email);

        SendMail::mail(
            $this->receiver,
            $this->subject,
            $this->content,
            $this->headers,
        );
    }

    /**
     * Set the value of content
     */
    public function setMessageContent()
    {
        $username = $this->username;

        $email = $this->new_email;

        $role = $this->getUserRole($this->user);

        $login = route('login');

        $signature = $this->signature;


        $this->content = view(
            'auth.mails.email-changed-confirm',
            compact('username', 'email', 'role', 'login', 'signature')
        )->render();
    }

    private function getUserRole($user)
    {
        if ($user) {
            if ($user->isAdminAndOwner()) return 'Owner';
            else if ($user->isAdmin()) return 'Admin';
            else if ($user->isUser()) return 'User';
        }
    }
}
