<?php

namespace App\Http\Requests;

use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;
use Illuminate\Foundation\Http\FormRequest;

class changePasswordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'currentpassword' => ['required', 'max:255'],
            'password' => ['required', 'confirmed', 'max:16', Password::min(8)
                ->letters()
                ->mixedCase()
                ->numbers()],
        ];
    }

    public function messages()
    {
        $password_validation_msg = "Your :attribute must meet the following requirements: Between 8 and 16 characters long, contain at least one uppercase letter, one lowercase letter, one number.";

        return [
            'currentpassword.required' => "Current password field is required.",
            'password.confirmed' => 'Your New Password and confirmation password do not match. Please make sure they match before proceeding.',
            'password.required' => ':attribute can\'t be empty.',
            'password.confirmed' => 'Password and confirmation password do not match. Please make sure they match before proceeding.',
            'password.mixed' => $password_validation_msg,
            'password.letters' => $password_validation_msg,
            'password.symbols' => $password_validation_msg,
            'password.numbers' => $password_validation_msg,

        ];
    }
}