<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateGeneralSettingsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "allow_register" => ["nullable", "in:1"],
            "from_name" => ["required", "max:255"],
            "from_email" => ["required", "email", "max:255"],
            "mail_signature" => ["required", "max:255"],
            "timezone" => ["required", "max:255"],
            "cronjobs_created" => [Rule::requiredIf(function () {
                return !(isDocker() || isHostedVersion());
            })],
        ];
    }

    public function messages()
    {
        return [
            "from_email.required" => "Please enter a valid email in the \"From Email\" field. All emails sent from Smart Report Maker will have this email address as the \"From\" and \"Reply To\" address.",
            "from_email.email" => "Please enter a valid email in the \"From Email\" field. All emails sent from Smart Report Maker will have this email address as the \"From\" and \"Reply To\" address.",
            "from_name.required" => "Please enter a valid text in the \"From Name\" field. This name provides a recognizable sender identity to your recipients. For example, you can use your company name.",
            "mail_signature.required" => "Please enter a valid signature in the \"Mail signature\" field. This text will be included at the end of all email notifications sent by the system.",
            "mail_signature.max" => "Mail signature should be 255 characters or less.",
            "timezone.required" => "Please select a time zone. This time zone will be utilized throughout the system, particularly in any scheduled processes.",
            "cronjobs_created.required" => "Kindly make sure to create needed cronjobs, then please check the confirmation checkbox."

        ];
    }

    public function validated($key = null, $default = null): array
    {
        return array_merge(parent::validated(), ['cronjobs_created' => null]);
    }
}
