<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckInternalRequest
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $internalToken = $request->header('X-Internal-Request');

        if ($internalToken !== config('srm_install_config.security_key')) {
            return response()->json(['error' => 'Unauthorized'], 403);
        }

        return $next($request);

    }
}
