<?php

namespace App\Http\Controllers;

use App\Models\Resource;
use App\Jobs\SendReportJob;
use Illuminate\Http\Request;
use App\Mails\ReportTestMail;

class TestReportcontroller extends Controller
{
    public function show()
    {
        return view('dashboard.test.show');
    }

    public function send(Request $request)
    {
        $report = Resource::where('module_id', 2)->latest()->first();

        $this->generateReport($report);

        $receivers = config('srm_config.dashboard.report_receivers', []);

        foreach ($receivers as $receiver) {
            dispatch(new SendReportJob($request->server(), $report, auth()->user(), $receiver));
        }

        dd("job dispated");
    }


    private function generateReport(Resource $report)
    {
        $url = request()->host() .$report->getReportUrl() . "?export=pdf1&save=1";
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);

            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($response === false) {
                return false;
            }

            if ($httpCode == 200) {
                return true;
            }

            return false;
        } catch (\Exception $e) {

            return $e->getMessage();
        }

    }
}
