<?php

namespace App\Http\Controllers\Charts\Wizard;

use App\Models\Resource;
use App\Services\ChartService;
use App\Services\GroupService;
use App\Services\CategoryService;
use App\Http\Controllers\Controller;
use App\Services\DataConnectionService;
use App\Services\DataConnectionTablesService;
use App\Http\Requests\Chart\ApperanceStepRequest;

class ApperanceStepController extends Controller
{
    public $chartService;
    public $categoryService;
    public $dataConnectionService;
    public $dataConnectionTablesService;
    public $groupService;

    public function __construct(
        ChartService $chartService,
        CategoryService $categoryService,
        DataConnectionService $dataConnectionService,
        DataConnectionTablesService $dataConnectionTablesService,
        GroupService $groupService
    ) {
        $this->chartService                = $chartService;
        $this->categoryService             = $categoryService;
        $this->dataConnectionService       = $dataConnectionService;
        $this->dataConnectionTablesService = $dataConnectionTablesService;
        $this->groupService                = $groupService;
    }

    public function show()
    {

        if (checkDemo()) {
            return $this->edit($this->chartService->getRecentChart());
        }

        $this->chartService->showChartTypeStep();

        $charts = $this->chartService->chartTypes();

        $categories  = $this->categoryService->getCategories();
        $connections = $this->dataConnectionService->getAllConnections();
        $groups      = auth()->user()->isAdminOrOwner() ? $this->groupService->getAllGroups() : [auth()->user()->group];

        $dateRanges = $this->chartService->dateRanges();
        $timeScales = $this->chartService->timeScales();

        return view(
            'dashboard.charts.wizard.index',
            compact(
                'charts',
                'categories',
                'connections',
                'groups',
                'dateRanges',
                'timeScales'
            )
        );
    }

    public function store(ApperanceStepRequest $request)
    {
        $this->chartService->storeApperanceStep($request);

        return response()->json([
            'message' => 'success'
        ]);
    }

    public function edit(Resource $chart)
    {
        [
            $chartsTypes,
            $chart,
            $categories,
            $connections,
            $groups,
            $tables,
            $xTableColumns,
            $yTableColumns,
            $xColumnType,
            $dateRanges,
            $timeScales,
            $textualCount,
            $dataFilterItems
        ] = $this->chartService->edit($chart);

        return view(
            'dashboard.charts.wizard.edit',
            compact(
                'chartsTypes',
                'chart',
                'categories',
                'connections',
                'groups',
                'tables',
                'xTableColumns',
                'yTableColumns',
                'xColumnType',
                'dateRanges',
                'timeScales',
                'textualCount',
                'dataFilterItems'
            )
        );
    }

}
