<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\Http\Request;
use App\Services\CategoryService;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\StoreCategoryRequest;
use App\Http\Requests\UpdateCategoryRequest;

class CategoryController extends Controller
{
    public $categoryService;

    public function __construct(CategoryService $categoryService)
    {
        $this->categoryService = $categoryService;

        $this->middleware(OnlyFullVersion::class)->only(
            [
                'store',
                'update',
                'destroy',
            ]
        );
    }

    public function index()
    {
        $categories = $this->categoryService->getCategories();

        return view('dashboard.categories.index', compact('categories'));
    }

    public function store(StoreCategoryRequest $request)
    {
        $this->categoryService->store($request->validated());

        return response()->json([
            "message" => "New Category saved successfully"
        ]);
    }

    public function edit(Category $category)
    {
        return view('dashboard.categories.edit', compact('category'));
    }

    public function update(UpdateCategoryRequest $request, Category $category)
    {

        $this->categoryService->update($request->validated(), $category);
        return response()->json([
            "message" => "\"{$category->name}\" is edited successfully"
        ]);
    }


    public function destroy(Category $category)
    {
        $this->categoryService->destory($category);
        return response()->json([
            'message' => 'This Category has been successfully deleted!'
        ]);
    }
}
