<?php

/**
 * Smart Report Maker
 * Version 9.0.0
 * Author : Webuccino
 * All copyrights are preserved to Webuccino
 * URL : http://mysqlreports.com/
 *
 */

if (!defined("DIRECTACESS")) {
    exit("No direct script access allowed");
}

class MysqliHandler
{

    protected $host,
    $user,
    $pass,
    $db,
    $link,
    $debug     = false,
    $numOfRows = '';

    public function __construct($host, $user, $pass, $isDebug, $db)
    {
        $this->is_debug($isDebug);
        $this->host = $host;
        $this->user = $user;
        $this->pass = $pass;
        $this->db   = $db;
        $this->link = $this->connect();
    }

    private function connect()
    {

    }

    // this function make query to fetch data from database ( Like using SELECT & SHOW ), this function return array and not handler
    public function query($sqlStatement, $keyType = "NUM", $params = array())
    { // $keyType = ASSOC, NUM, BOTH

    }

    public function command($sqlStatement, $params = array())
    {

    }

    private function get_result($result, $keyType)
    {
        $fetchedData = array();

        while ($row = $result->fetch_array($keyType)) {
            $fetchedData[] = $row;
        }

        return $fetchedData;
    }

    public function sanitize_values($string)
    {
        $cleaned_string = $string;

        $this->debug_mode('sanitize_values', 'info', '#input string for the sanitize function : ' . $string);

        if ($this->link) {
            $string         = str_replace(array("=", "*", " union", "\t", " delete", " select", " insert", " limit", " null", " table", "(", ")", " where", " update"), "", strtolower($string));
            $cleaned_string = $this->link->real_escape_string($string);

            $this->debug_mode('sanitize_values', 'success', '#sanitized string : ' . $cleaned_string);
        }

        return $cleaned_string;
    }

    // this function to check if connection failed or succeeded
    public function is_connection_failed()
    {

// if connection failed return true
        if ($this->link === false) {
            return true;
        } else {
            return false;
        }

    }

    // this function return number of rows for current query
    public function get_num_rows()
    {
        return $this->numOfRows;
    }

    // this function display what's happened while object of this class start actions ( Just work when debug = true )
    private function debug_mode($functionName, $type, $msg)
    {

        if ($this->debug) {
            $color = "black";

// by default
            if ($type === "error") {
                $color = "red";
            }

            // error
            else

            if ($type === "success") {
                $color = "green";
            }

            // success
            else

            if ($type === "info") {
                $color = "blue";
            }

            // info

            logging("\n ## DbHandler -> mysqli  : " . $msg);
        }

    }

    // this function return database handler type
    public function get_db_handler_type()
    {
        return 'mysqli';
    }

    // this function set debug mode
    public function is_debug($bool)
    {

        if ($bool === true) {
            $this->debug = true;
        } else {
            $this->debug = false;
        }

    }

    // this function for close connection
    public function close_connection()
    {

        if ($this->link) {
            $this->link->close();
            $this->link = null;
        }

    }

    public function do_transaction($sqlStatement_array)
    {

    }

}
