$(document).ready(function () {

    function getCaretPosition() {
        var ctlTextArea = document.getElementById('body');
        position = ctlTextArea.selectionStart;
        return position;
    }

    jQuery.fn.extend({
        insertAtCaret: function (myValue) {
            return this.each(function (i) {
                if (document.selection) {
                    //For browsers like Internet Explorer
                    this.focus();
                    sel = document.selection.createRange();
                    sel.text = myValue;
                    this.focus();
                }
                else if (this.selectionStart || this.selectionStart == '0') {
                    //For browsers like Firefox and Webkit based
                    var startPos = this.selectionStart;
                    var endPos = this.selectionEnd;
                    var scrollTop = this.scrollTop;
                    this.value = this.value.substring(0, startPos) + myValue + this.value.substring(endPos, this.value.length);
                    this.focus();
                    this.selectionStart = startPos + myValue.length;
                    this.selectionEnd = startPos + myValue.length;
                    this.scrollTop = scrollTop;
                } else {
                    this.value += myValue;
                    this.focus();
                }
            })
        }
    });

    $('#add-first-name').click(function (event) {
        event.preventDefault();
        $("#body").insertAtCaret(' {{user first name}} ');
    });

    $('#add-email-signature').click(function (event) {
        event.preventDefault();

        $("#body").insertAtCaret(' {{email signature}} ');
    });


    $(document).on('change', '#frequency', function () {
        if ($(this).val() != "hourly" && $(this).val() != "") {
            $("#frequency-container").removeClass("col-12").addClass("col-4");

            if ($(this).val() == "daily") {
                $("#frequency-container").removeClass("col-12").addClass("col-6");
                $("#sending-time").removeClass("col-12 col-4").addClass("col-6");

                $("#sending-time").show();
                $("#sending-time select").attr("disabled", false);
                $("#sending-weekday").hide();
                $("#sending-weekday select").attr("disabled", true);

                $("#sending-monthday").hide();
                $("#sending-monthday select").attr("disabled", true);


            }
            else if ($(this).val() == "weekly") {
                $("#frequency-container").removeClass("col-12 col-6").addClass("col-4");
                $("#sending-time").removeClass("col-12 col-6").addClass("col-4");
                $("#sending-time").show();
                $("#sending-time select").attr("disabled", false);

                $("#sending-weekday").show();
                $("#sending-weekday select").attr("disabled", false);


                $("#sending-monthday").hide();
                $("#sending-monthday select").attr("disabled", true);

            }
            else if ($(this).val() == "monthly") {
                $("#sending-monthday").show();
                $("#frequency-container").removeClass("col-12 col-6").addClass("col-4")
                $("#sending-monthday select").attr("disabled", false);
                $("#sending-time").removeClass("col-12 col-6").addClass("col-4");
                $("#sending-time").show();
                $("#sending-time select").attr("disabled", false);

                $("#sending-weekday").hide();
                $("#sending-weekday select").attr("disabled", true);
            }
        } else {
            $("#frequency-container").removeClass("col-6").addClass("col-12");
            $("#times-container").hide();

            $("#sending-time").hide();
            $("#sending-weekday").hide();
            $("#sending-monthday").hide();
        }
    });

    $(document).on('click', '#close-btn', function (params) {

        window.location = $(this).data('url');

    });

    $(document).on('click', '#reset-btn', function (params) {

        window.location.reload();

    });
});

