<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ScheduledTaskHistory extends Model
{
    use HasFactory;
    protected $primaryKey = 'id';
    protected $connection = 'mysql';
    public $timestamps = false;

    protected $fillable = [
        'task_id',
        'start_sending_date',
        'end_sending_date',
        'error_message',
        'status',
        'total_sent',
        'total_failed',
        'next_sending_date',
        'info'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}scheduled_task_history";
    }

    public static function tableName()
    {
        return with(new static())->getTable();
    }

    public function tasks()
    {
        return $this->belongsTo(ScheduledTask::class);
    }

    public function successRate()
    {
        if(($this->total_sent + $this->total_failed) == 0) {
            return 0;
        }

        return ceil(($this->total_sent / ($this->total_sent + $this->total_failed)) * 100);
    }


}
