<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ModulePermission  extends Pivot
{
    use HasFactory;

    protected $connection = 'mysql';


    protected $fillable = [
        'group_id',
        'module_id',
        'can_add_new',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}modules_premissions";
    }

    public function groups()
    {
        return $this->belongsTo(Group::class, 'group_id');
    }
}
