<?php

namespace App\Models;

use App\Models\Resource;
use Illuminate\Support\Facades\File;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class DashboardWidget extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $primaryKey = 'id';
    protected $connection = 'mysql';

    protected $fillable = [
        'title',
        'report_lists',
        'dashboard_id',
        'resource_id',
    ];

    protected $casts = [
        'report_lists' => 'array',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}widgets";
    }

    public function resource()
    {
        return $this->belongsTo(Resource::class, 'resource_id');
    }

}
