<?php

namespace App\Mails\ScheduledTaskMail;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use App\Exceptions\SystemErrorException;

class SendScheduledMail
{
    public static function mail($to, $subject, $content, $attachment)
    {
        static::sendMail($to, $subject, $content, $attachment);
    }


    private static function sendMail($to, $subject, $content, $attachment)
    {
        Mail::send([], [], function ($message) use ($to, $subject, $content, $attachment) {

            $message->to($to)
                ->subject($subject)
                ->html(nl2br($content));
            if(file_exists($attachment)) {
                $message->attach($attachment);
            }

        });
    }
}
