<?php

namespace App\Mails\ScheduledTaskMail;

use App\Mails\MailTrait;
use App\Models\Resource;
use App\Mails\MailInterface;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Config;
use App\Exceptions\SystemErrorException;
use Illuminate\Validation\ValidationException;

class ScheduledReportMail implements MailInterface
{
    use MailTrait;

    public $task;
    public $report;
    private $receiver;
    private $body;
    private $subject;
    private $content;
    private $username;
    private $signature;
    private $headers;

    public function __construct($task, $report, $receiver, $body)
    {
        $this->task = $task;
        $this->report = $report;
        $this->receiver = $receiver;
        $this->body = $body;
    }


    public function send()
    {
        try {
            SendScheduledMail::mail(
                $this->receiver['email'],
                $this->task->subject,
                $this->body,
                $this->report
            );
        } catch(\Exception $e) {
            throw new \Exception($e->getMessage());
        }
    }

    public function setMessageContent()
    {
        $this->content = $this->body;
    }


}
