<?php

namespace App\Jobs;

use App\Models\User;
use App\Mail\SendReportMail;
use App\Mails\ReportTestMail;
use App\Models\Resource;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Mail;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Http\Request;

class SendReportJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     */
    public $user;
    public $report;
    public $request;
    public $receiver;
    public function __construct($request, Resource $report, User $user, $receiver)
    {
        $this->user = $user;
        $this->report = $report;
        $this->request = $request;
        $this->receiver = $receiver;
    }

    private function getReportUrl()
    {
        $public_uri = explode("/index.php", $this->request["PHP_SELF"])[0];

        return "$public_uri/srm_modules/{$this->report->url}";
    }

    private function getReportPdf()
    {
        $reportPath = explode('/', $this->getReportUrl());

        array_pop($reportPath);

        $reportPath = implode('/', $reportPath);

        return $this->request['DOCUMENT_ROOT']. "$reportPath" . "/".str_replace(' ', '', $this->report->name).'-singlepage.pdf';
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        (new ReportTestMail($this->getReportPdf(), $this->user))
        ->setReceivcer($this->receiver)
        ->send();
    }



}
