<?php

namespace App\Http\Requests\Chart;

use Illuminate\Foundation\Http\FormRequest;

class SettingStepRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");

        return [
            'name'          => ['required', "unique:{$prefix}analytics_resources,name", 'regex:/^[a-zA-Z_][a-zA-Z0-9_ ]*$/'],
            'title'         => ['required'],
            'category'      => ['required'],
            'connection'    => ['required'],
            'security_type' => ['required'],
            'groups'        => ['nullable', 'array']
        ];
    }

    public function messages()
    {
        return [
            'name.required'          => trans('charts.validations.required.name'),
            'name.unique'            => trans('charts.validations.unique.name'),
            'name.regex'             => trans('charts.validations.regex'),
            'title.required'         => trans('charts.validations.required.title'),
            'title.regex'            => trans('charts.validations.regex'),
            'category.required'      => trans('charts.validations.required.category'),
            'connection.required'    => trans('charts.validations.required.connection'),
            'security_type.required' => trans('charts.validations.required.security_type')
        ];
    }
}
