<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class OnlyFullVersion
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        if (!checkDemo()) {
            return $next($request);
        }

        return $request->wantsJson()
        ? response()->json([
            'demo' => 'Available only in full version'
        ])
        : redirect()->back()->with('demo', 'Available only in full version');
    }

}