<?php

namespace App\Http\Controllers\Metrics\Wizard;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Metrics\SettingStepRequest;
use App\Http\Requests\Metrics\SettingStepUpdateRequest;
use App\Models\Resource;
use App\Services\ChartService;
use App\Services\MetricService;

class SettingStepController extends Controller
{
    public $metricService;
    public function __construct(MetricService $metricService)
    {
        $this->metricService = $metricService;
    }

    public function store(SettingStepRequest $request)
    {

        $this->metricService->storeSettingStep($request);

        return response()->json([
            'success'
        ]);
    }


    public function update(SettingStepUpdateRequest $request, Resource $metric)
    {
        $this->metricService->updateSettingStep($request, $metric);

        return response()->json([
            'success'
        ]);
    }
}
