<?php

namespace App\Http\Controllers;

use App\Services\DataConnectionService;
use App\Services\DataConnectionTablesService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DataConnectionTablesController extends Controller
{
    public $dataConnectionTablesService;

    public function __construct(DataConnectionTablesService $dataConnectionTablesService)
    {
        $this->dataConnectionTablesService = $dataConnectionTablesService;
    }

    public function getTables($connection)
    {

        session()->put("chart_session_wizart_settings", [
            "connection" => $connection
        ]);

        return response()->json([
            "success" => true,
            "data" => $this->dataConnectionTablesService->getTables($connection)
        ]);
    }

    public function getColumns($connection, $table)
    {
        $types = [];

        if(isset(request()->query()["types"])) {
            $types = json_decode((request()->query()["types"]));
        }

        return response()->json([
            "success" => true,
            "data" => $this->dataConnectionTablesService->getColumns($connection, $table, $types)
        ]);
    }



    public function getColumnType($connection, $table, $column)
    {
        return response()->json([
            "success" => true,
            "data" => $this->dataConnectionTablesService->getColumnType($connection, $table, $column)
        ]);

    }

    public function getValues($connection, $table, $column)
    {
        return response()->json([
            "success" => true,
            "data" => $this->dataConnectionTablesService->getValues($connection, $table, $column)
        ]);

    }
}
