<?php

namespace App\Http\Controllers;

use App\Models\Dashboard;
use App\Services\HomeService;
use App\Services\DashboardService;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\StoreDashboardRequest;
use App\Http\Requests\UpdateDashboardRequest;

class DashboardController extends Controller
{
    private $homeService;
    private $dashboardService;
    public function __construct(DashboardService $dashboardService, HomeService $homeService)
    {
        $this->homeService      = $homeService;
        $this->dashboardService = $dashboardService;

        $this->middleware(OnlyFullVersion::class)->only([
            'store',
            'update',
            'moveUp',
            'moveDown',
            'destroy'
        ]);

    }

    public function index()
    {
        $dashboards = $this->dashboardService->index();

        return view('dashboard.dashboards.index', compact('dashboards'));
    }

    public function show(Dashboard $dashboard)
    {
        [$dashboard, $paginatedWidgets] = $this->dashboardService->show($dashboard);
        $resourceTypes                  = $this->homeService->getResourceTypes();

        return view('dashboard.dashboards.show', compact('dashboard', 'paginatedWidgets', 'resourceTypes'));

    }

    public function create()
    {

        if (checkDemo()) {
            $dashboard = $this->dashboardService->getRecentDashboard();
            return view('dashboard.dashboards.partials._add-dashboard-modal-demo', compact('dashboard'));

        }

        return view('dashboard.dashboards.partials._add-dashboard-modal');

    }

    public function edit(Dashboard $dashboard)
    {
        return view('dashboard.dashboards.partials._edit-dashboard-modal', compact('dashboard'));
    }

    public function store(StoreDashboardRequest $request)
    {
        $this->dashboardService->store($request);

        return response()->json([
            'success' => true,
            'message' => trans('dashboards.messages.store_dashboard')
        ]);

    }

    public function update(UpdateDashboardRequest $request, Dashboard $dashboard)
    {

        if (!checkDemo()) {
            $this->dashboardService->update($request, $dashboard);

        }

        return response()->json([
            'success' => true,
            'message' => trans('dashboards.messages.save_dashboard')
        ]);
    }

    public function moveUp(Dashboard $dashboard)
    {
        $this->dashboardService->moveUp($dashboard);

        return response()->json([
            'message' => trans('dashboards.messages.move_up')
        ]);

    }

    public function moveDown(Dashboard $dashboard)
    {
        $this->dashboardService->moveDown($dashboard);

        return response()->json([
            'message' => trans('dashboards.messages.move_down')
        ]);

    }

    public function destroy(Dashboard $dashboard)
    {
        $this->dashboardService->destory($dashboard);

        return response()->json([
            'message' => trans('dashboards.messages.delete')
        ]);

    }

}