<?php

namespace App\Http\Controllers\Charts\Wizard;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Chart\SettingStepRequest;
use App\Http\Requests\Chart\SettingStepUpdateRequest;
use App\Models\Resource;
use App\Services\ChartService;

class SettingStepController extends Controller
{
    public $chartService;
    public function __construct(ChartService $chartService)
    {
        $this->chartService = $chartService;
    }

    public function store(SettingStepRequest $request)
    {

        $this->chartService->storeSettingStep($request);

        return response()->json([
            'success'
        ]);
    }


    public function update(SettingStepUpdateRequest $request, Resource $chart)
    {
        $this->chartService->updateSettingStep($request, $chart);

        return response()->json([
            'success'
        ]);
    }
}
