<?php require base_path_native('views/partials/head.php')?>
<?php require base_path_native('views/partials/pills.php')?>

<link href="<?=asset_native('assets/assets/css/loader.css')?>" rel="stylesheet" />

<div id="loading-loader">
  <div id="loader">
    <div class="loader-text"></div>
  </div>
</div>

<div class="tab-content">
  <div class="row"></div>
  <div class="row">
    <div class="col-sm-12">
      <div class="form-group">
        <label>Database Setup</label>
        <p class="description">
          To ensure the seamless functioning of Smart Report
          Maker, it's essential to include specific database
          tables. Each of these tables will carry the "srm_"
          prefix.
          <u>Kindly make sure to add these tables into the
            database you're already planning to use for
            future reporting.</u>
        </p>
      </div>
    </div>
  </div>
  <form id="database-form" data-path="<?=route_native('')?>" data-action="checkConnection">
    <div class="row">
      <div class="col-sm-5 col-sm-offset-1">
        <div class="form-group">
          <label>Database Type</label>
          <select class="form-control hostname" id="datasource">
            <?php

            foreach (config_native('srm_config.installer.data_sources') as $data_source): ?>
            <option value="<?=$data_source?>"><?=$data_source?></option>
            <?php endforeach?>
          </select>
        </div>
      </div>
      <div class="col-sm-5">
        <div class="form-group">
          <label for="host">Host</label>
          <div class="input-container" style="display: flex; align-items: center;gap:10px">
            <input id="host" name="host" type="text" class="form-control" placeholder="localhost" required <?php

              if (is_docker() || is_hosted_version()): ?>
              value="<?php echo get_environment_variable('DEFAULT_CONNECTION_HOST'); ?>" <?php else: ?>
              value="localhost" <?php endif; ?> />
            <?php

            if (is_docker() || is_hosted_version()): ?>
            <span class="glyphicon glyphicon-info-sign" style="color: #68b3c8" data-toggle="tooltip"
              data-placement="right" data-container="body"
              data-title="If your database is located on the same machine where this installation is running (and Docker is not used for the database itself, only for the app), use host.docker.internal. This instructs Docker to resolve to the IP address of the host machine. If your database is in a separate container on the same machine, use the name of that container (container_name). For a newly created database as per our command line instructions for creating a DB, use srm_db as the container name, and therefore, the hostname. Finally, if your database is hosted on a remote server, use the IP address or hostname of that server."></span>

            <?php else: ?>
            <span class="glyphicon glyphicon-info-sign" style="color: #68b3c8" data-toggle="tooltip"
              data-placement="right" data-container="body"
              data-title="The hostname or IP address of your database server. If it is hosted on the same machine as the system, please use localhost."></span>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
    <div>
      <div class="row">
        <div class="col-sm-5 col-sm-offset-1">
          <div class="form-group">
            <div class="input-container">
              <label for="db_name">Database Name</label>
              <input type="text" id="db_name" name="db_name" class="form-control database"
                placeholder="Enter Database Name" required
                value="<?php echo get_environment_variable('DEFAULT_CONNECTION_DB'); ?>" />

            </div>
          </div>
        </div>
        <div class="col-sm-5">
          <div class="form-group">
            <div class="input-container">
              <label for="db_user">User</label>
              <input type="text" id="db_user" name="db_user" class="form-control" placeholder="User" required
                value="<?php echo get_environment_variable('DEFAULT_CONNECTION_USER'); ?>" />

            </div>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-5 col-sm-offset-1">
          <div class="form-group">
            <div class="input-container">
              <label for="db_password">Password</label>
              <input type="password" id="db_password" name="db_password" class="form-control"
                placeholder="Enter Password" required />
            </div>
          </div>
        </div>
        <div class="col-sm-5">
          <div class="form-group">
            <label for="db_port">Port (Optional)</label>
            <input type="text" id="db_port" class="form-control database" placeholder="3306"
              value="<?php echo get_environment_variable('DEFAULT_CONNECTION_PORT'); ?>" />
          </div>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-xs-12 text-center">
        <input type="submit" class="btn btn-fill btn-success btn-wd" id="test-connection" name="test"
          value="Test Connection" />
      </div>
      <div style="margin-top: 10px" class="msg text-center text-danger pt-2" data-toggle="tooltip"></div>

    </div>
  </form>
  <div style="margin: 20px" class="wizard-footer">
    <div class="pull-right">
      <a class="btn btn-fill btn-warning btn-wd btn-next" href="<?=route_native('/profile')?>" <?php

    if (Webuccino\Install\Core\Session::get('connection-success') === false) {
        echo 'disabled';
    }

?>>Next</a>
    </div>
    <div class="pull-left">
      <?php

      if (!(is_docker() || is_hosted_version())): ?>
      <a class="btn btn-previous btn-default btn-wd" href="<?=route_native('/permissions')?>">Previous</a>

      <?php else: ?>
      <a class="btn btn-previous btn-default btn-wd" href="<?=route_native('/')?>">Previous</a>

      <?php endif; ?>
    </div>
    <div class="clearfix"></div>
  </div>

</div>
<?php require base_path_native('views/partials/confirm-db-modal.php')?>

<?php require base_path_native('views/partials/footer.php')?>