<?php

namespace Webuccino\Install\seeder;

use Illuminate\Database\Capsule\Manager as Capsule;

class SettingsSeeder
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix');

        $this->table = $this->prefix . 'Settings';
    }

    public function run()
    {
        $settings = [
            'system_logo' => 'dist/images/srm-logo.jpg',
            'mail_retry_count' => '3',
            'mail_retry_interval_min' => '10',
            'scheduling_cron_job_interval' => 15,
            'log_sending_batch_reports_task' => true,
            'pdf_attachments' => 'config/pdfs/',
            'default_pivot_table_theme' => 'cosmo',
            'default_pivot_table_height' => 1000,
            'shared_key' => base64_encode(random_bytes(256)),
            'auto_refresh' => 5
        ];
        
        foreach ($settings as $key => $value) {
            $exists = Capsule::table($this->table)->where('settings_key', $key)->exists();
            if (!$exists) {
                Capsule::table($this->table)->insert([
                    'settings_key' => $key,
                    'settings_value' => $value,
                ]);
            }
        }

    }
}