<?php

namespace Webuccino\Install\seeder;

use Illuminate\Database\Capsule\Manager as Capsule;

class InstalledVersionsSeeder
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix');

        $this->table = $this->prefix . 'installed_versions';
    }

    public function run()
    {
        $version = config_native('srm_config.installer.version_to_install', "v11.0.1");

        $existingRow = Capsule::table($this->table)
        ->where('install_last_success_step', 'finish')
        ->first();

        if ($existingRow) {
            Capsule::table($this->table)
                ->where('id', $existingRow->id) // or use another unique identifier
                ->update([
                    'version'                   => $version,
                    'batch'                     => $this->getLastBatch(),
                ]);
        } else {
            Capsule::table($this->table)->updateOrInsert(
                ['version' => $version],
                [
                    'is_current'                => true,
                    'install_last_success_step' => 'migrate',
                    'is_install_complete'       => false,
                    'install_url'               => $this->getInstalledVersion(),
                    'installation_date'         => date('Y-m-d H:i:s'),
                    'batch'                     => $this->getLastBatch()
                ]
            );
        }

    }

    public function getInstalledVersion()
    {
        $php_self_path = explode("/install", base_url())[0];

        return $_SERVER["HTTP_HOST"] ?? "" . $php_self_path;
    }

    public function getLastBatch()
    {
        if (Capsule::table($this->prefix . 'migrations')->exists()) {
            return Capsule::table($this->prefix . 'migrations')
            ->latest('created_at')
            ->first()->batch;
        } else {
            return 0;
        }

    }
}
