<?php

namespace Webuccino\Install\seeder;

use Illuminate\Database\Capsule\Manager as Capsule;

class EmbeddingPreferenceSeeder
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix');

        $this->table = $this->prefix . 'embedding_preferences';
    }

    public function run()
    {
        $settings = [
            'custom_php_before_embed' => NULL,
            'custom_php_after_embed' => NULL,
            'custom_html_before_embed' => NULL,
            'custom_html_after_embed' => NULL,
            'iframe_width' => '100',
            'iframe_height' => '800',
            'embed_token_life_span' => 20,
        ];
        
        foreach ($settings as $key => $value) {
            $exists = Capsule::table($this->table)->where('key', $key)->exists();
            if (!$exists) {
                Capsule::table($this->table)->insert([
                    'key' => $key,
                    'value' => $value,
                ]);
            }
        }

    }
}