<?php

namespace Webuccino\Install\seeder;

use Illuminate\Database\Capsule\Manager as Capsule;

class CategoriesSeeder
{

    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix');

        $this->table = $this->prefix . 'categories';
    }

    public function run()
    {
        $hasAnyRows = Capsule::table($this->table)->exists();
        
        if(!$hasAnyRows){
            Capsule::table($this->table)->insert(
                [
                    'name' => 'Unassigned',
                    'description' => 'Entities lacking a specific category can be listed here',
                    'icon'        => '<i class="fa-solid fa-folder"></i>',
                    'order'       => 999999
                ],
            );
    
        }
    }
}
