<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateWidgetsTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'widgets';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('id');
            $table->string('title', 255)->nullable();
            $table->text('report_lists')->nullable();
            $table->foreignId('dashboard_id')->nullable()->references('id')->on($this->prefix . 'dashboards')->onUpdate('cascade')->onDelete('set null');
            $table->foreignId('resource_id')->nullable()->references('id')->on($this->prefix . 'analytics_resources')->onUpdate('cascade')->onDelete('set null');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}
