<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateModulesTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'modules';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {

        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('id');
            $table->string('name', 255);
            $table->string('logo', 255)->nullable();
            $table->boolean('is_active');
            $table->string('description', 255);
            $table->foreignId('parent_id')->nullable()->references('id')->on($this->prefix . 'modules')->onUpdate('cascade')->onDelete('set null');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}
