<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateJobsTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'jobs';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {

        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('id');
            $table->string('queue', 191)->index();
            $table->longText('payload');
            $table->unsignedTinyInteger('attempts');
            $table->unsignedInteger('reserved_at')->default(null)->nullable();
            $table->unsignedInteger('available_at');
            $table->unsignedInteger('created_at');
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}
