<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateInstalledVersionsTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'installed_versions';
    }

    public function getTableName()
    {
        return $this->table;
    }


    public function run()
    {

        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('id');
            $table->string('version', 20)->nullable();
            $table->boolean('is_current')->nullable();
            $table->string('install_last_success_step')->nullable();
            $table->boolean('is_install_complete')->nullable();
            $table->timestamp('installation_date')->nullable();
            $table->string('batch', 255)->nullable();
            $table->string('error', 255)->nullable();
            $table->string('install_url', 255)->nullable();
            $table->timestamp('created_at')->useCurrent();
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}
