<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateEmbedLogTable
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'embed_log';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {

        $prefix = $this->prefix;

        Capsule::schema()->create($this->table, function (Blueprint $table) use ($prefix) {
            $table->id('id');
            $table->foreignId('access_key_id')->nullable()->references('id')->on($prefix . 'access_keys')->onUpdate('cascade')->onDelete('set null');
            $table->foreignId('token_id')->nullable()->references('id')->on($prefix . 'embed_tokens')->onUpdate('cascade')->onDelete('set null');
            $table->string('resource_url', 255);
            $table->string('attembed_ip', 45);
            $table->text('origin');
            $table->boolean('success');
            $table->string('reason', 255);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}