<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class AddRelationAndParametersToResourceConfiguration
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'resource_configuration';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        Capsule::schema()->table($this->table, function (Blueprint $table) {
            $table->enum('relation',['standalone','parent','linked','intermediate'])
            ->after('chart_type')->nullable();
            $table->text('parameters',)
            ->after('relation')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->table($this->table, function (Blueprint $table) {
            $table->dropColumn('relation');
            $table->dropColumn('parameters');
        });
    }
}
